package com.bxm.newidea.recommend.handler.forum;

import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.recommend.framework.AbstractForumRecommender;
import com.bxm.newidea.recommend.AbstractRecommender;
import com.bxm.newidea.recommend.filter.RecommendFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *     论坛列表首页推荐器：
 *          优先推荐24小时之内的精华帖；
 *          若24小时之内的精华帖推荐数量不够，则按时间降序推荐。
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/3
 */
@Service
@Deprecated
public class ForumHomePageRecommender extends AbstractForumRecommender {

    @Autowired
    private FixForumHomePageRecommender fixForumHomePageRecommender;

    @Autowired
    private RecentlyForumHomePageRecommender recentlyForumHomePageRecommender;

    @Autowired
    private RecommendFilter recommendFilter;

    public ForumHomePageRecommender() {
        super(1, 1);
    }

    @Override
    public List<Long> syncRecommend(ForumParam forumParam) {
        int num = forumParam.getPageSize();

        List<Long> mixRecommendResultList = new LinkedList<>();
        //1.获得混合推荐器
        List<AbstractRecommender> recommenderWorkers = new ArrayList<>();
        recommenderWorkers.add(recentlyForumHomePageRecommender);
        recommenderWorkers.add(fixForumHomePageRecommender);
        Iterator<AbstractRecommender> iterator = recommenderWorkers.iterator();

        //2.如果有多个推荐器则循环调用
        //想要推荐的数量
        int fetchNum;
        //已推荐的数量
        int recommendNum = 0;
        while (iterator.hasNext()) {
            AbstractRecommender recommender = iterator.next();
            //获取推荐器权重对应的推荐数量
            fetchNum = num;
            //如果权重推荐数量大于剩余推荐数量，则选择剩余数量
            if (num - recommendNum < fetchNum) {
                fetchNum = num - recommendNum;
                forumParam.setPageSize(fetchNum);
            }

            List<Long> results = recommender.recommend(forumParam);
            recommendNum += results.size();
            mixRecommendResultList.addAll(results);

            if (mixRecommendResultList.size() >= num) {
                break;
            }
        }

        //3.全局黑名单过滤
        mixRecommendResultList = recommendFilter.postFilter(mixRecommendResultList);

        //4.去重
        mixRecommendResultList = removeDuplicatePostResult(mixRecommendResultList);

        return mixRecommendResultList.size() > num ? mixRecommendResultList.subList(0, num) : mixRecommendResultList;
    }

    private List<Long> removeDuplicatePostResult(List<Long> list) {
        return list.stream().distinct().collect(Collectors.toList());
    }
}
