package com.bxm.newidea.recommend.handler.forum;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.AppConstant;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.ForumPostMapper;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.recommend.framework.AbstractForumRecommender;
import com.bxm.newidea.vo.ForumTopPost;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

@Component
@Deprecated
public class RecentlyForumHomePageRecommender extends AbstractForumRecommender {

    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    private RedisListAdapter redisListAdapter;

    @Autowired
    private ForumPostMapper forumPostMapper;

    public RecentlyForumHomePageRecommender() {
        super(1, 1);
    }

    @Override
    public List<Long> syncRecommend(ForumParam forumParam) {
        long begin = System.currentTimeMillis();

        Long userId = forumParam.getUserId();
        Integer operationId = forumParam.getOperationId();

        // 已推荐redis key
        KeyGenerator recommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey(OperationLocationEnum.getName(operationId)).appendKey("browsingKey");
        // 最后一次推荐记录
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey(OperationLocationEnum.getName(operationId)).appendKey("lastreadtime");
        // 用户刚发的帖子（一小时以内需要置顶）
        KeyGenerator postUserTopKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey("top");
        // 最新推荐池
        KeyGenerator forumPostPoolKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey(OperationLocationEnum.getName(operationId)).appendKey("recentlypool");

        //1.上划不走最新推荐池
        if (AppConstant.ACTION_TYPE_UP == forumParam.getActionType()) {
            return new ArrayList<>();
        }

        //2.下拉清空缓存池，保证下拉一定能取得数据
        this.redisSetAdapter.remove(recommendedKey);

        //用户发帖置顶
        List<Long> resultList = new ArrayList<>();
        Long postUserTopSize = redisListAdapter.size(postUserTopKey);
        if (postUserTopSize > 0) {
            List<ForumTopPost> forumTopPostList = redisListAdapter.leftIndex(postUserTopKey, postUserTopSize - 1, ForumTopPost.class).stream()
                    .filter(e -> e.getAreaCode().equals(forumParam.getAreaCode()))
                    .sorted(Comparator.comparing(ForumTopPost::getDisplayTime).reversed()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(forumTopPostList)) {
                List<Long> ids = forumTopPostList.stream().map(ForumTopPost::getId).collect(Collectors.toList());
                forumParam.setPageSize((forumParam.getPageSize() - forumTopPostList.size()));
                resultList.addAll(ids);
                redisSetAdapter.add(recommendedKey,resultList.toArray(new Long[0]));
                redisSetAdapter.expire(recommendedKey, NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
            }
        }

        //3.如果用户没有最后的阅读时间记录，则说明用户没有看过首页的东西，那么用户直接去固定的新闻池读数据即可（固定新闻池每5分钟更新一次）
        //如果用户存在最后的阅读时间记录，则去redis中查看是否存在最新推荐池，如果为空，则补充
        Date lastReadTime = redisStringAdapter.get(lastRecommendedKey, Date.class);
        if (null == lastReadTime) {
            return resultList;
        } else {
            long size = fillMixRecentlyPool(forumPostPoolKey, lastReadTime, forumParam.getAreaCode());
            if (size == 0) {
                return resultList;
            }
        }

        //4.对最新推荐池进行筛选
        this.recommendedFilter(forumPostPoolKey, recommendedKey, forumParam.getPageSize(), resultList);

        if (CollectionUtils.isNotEmpty(resultList)) {
            redisStringAdapter.set(lastRecommendedKey,new Date(),NewsCacheThresholdConfig.MIX_EXPIRE_LAST_READ_TIME);
        }
        logger.debug("同步推荐耗时：{}", System.currentTimeMillis() - begin);
        return resultList;

    }

    /**
     * 当发现最新推荐池为空的时候，填充最新推荐池
     *
     * @param mixRecentlyPoolKey 最新推荐池的key
     * @param lastReadTime       最后阅读时间
     * @param areaCode           地区编码
     * @return 填充的数量
     */
    private long fillMixRecentlyPool(KeyGenerator mixRecentlyPoolKey, Date lastReadTime, String areaCode) {
        long size = redisListAdapter.size(mixRecentlyPoolKey);
        if (size == 0) {
            //如果最新推荐是池的数量为0，则去拉去一批新的
            List<Long> mixRecommendResultList = forumPostMapper.selectRecentlyPostList(lastReadTime, areaCode);
            size = mixRecommendResultList.size();
            if (size != 0) {
                redisListAdapter.rightPush(mixRecentlyPoolKey, mixRecommendResultList.toArray(new Long[0]));
                redisListAdapter.expire(mixRecentlyPoolKey, NewsCacheThresholdConfig.MIX_EXPIRE_RECENTLY_POOL);
            }
        }
        return size;
    }

    /**
     * 对最新推荐池中的数据进行筛选
     *
     * @param mixRecentlyPoolKey redis中的最新推荐池key
     * @param mixRecordKey       redis中的推荐记录
     * @param num                数量
     * @param resultList         结果
     */
    protected void recommendedFilter(KeyGenerator mixRecentlyPoolKey,
                                     KeyGenerator mixRecordKey,
                                     Integer num,
                                     List<Long> resultList) {
        long begin = System.currentTimeMillis();

        //1.去往最新推荐池中去取得最新推荐池的容量
        long total = redisListAdapter.size(mixRecentlyPoolKey);
        logger.debug("[recentlyRecommendedFilter]redis拉取列表耗时：{} 列表长：{}", System.currentTimeMillis() - begin, total);

        //2.之前已经判断过这个最新推荐池是否已经是空了，并且是空的话会补充，所以这里如果判断是空的话，说明确实没有最新的数据了
        if (total == 0) {
            return;
        }

        List<Long> mixRecomendResultList = redisListAdapter.leftIndex(mixRecentlyPoolKey,total,Long.class);

        int i = 0;
        //3.遍历最新推荐池
        for (Long mixRecentlyPoolResult:mixRecomendResultList) {

            if (mixRecentlyPoolResult == null) {
                break;
            }

            //4.判断是否已被推荐过，如果没有则加入结果集并加入推荐记录
            this.generateResult(mixRecordKey, mixRecentlyPoolResult, resultList);

            i = i+1;

            //5.一旦数量达标，则退出循环
            if (resultList.size() >= num) {
                logger.info("[recentlyRecommendedFilter]已取得{}条最新混合推荐数据，功成圆满", num);
                break;
            }

        }
        redisListAdapter.leftTrim(mixRecentlyPoolKey, i, total);
        redisSetAdapter.add(mixRecordKey,resultList.toArray(new Long[0]));
        redisSetAdapter.expire(mixRecordKey, NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
        logger.info("[recentlyRecommendedFilter]bloom去重耗时：{}", System.currentTimeMillis() - begin);
    }

    /**
     * 判断是否已被推荐过，如果没有则加入结果集并加入推荐记录
     *
     * @param mixRecordKey          推荐记录key
     * @param id 当前的数据
     * @param resultList            结果集
     */
    private void generateResult(KeyGenerator mixRecordKey, Long id, List<Long> resultList) {
        Set<Long> record = redisSetAdapter.getAllMembers(mixRecordKey,Long.class);
        if (!record.contains(id)) {
            resultList.add(id);
            record.add(id);
        }
    }
}
