package com.bxm.newidea.recommend.handler.mix;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.AppConstant;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.recommend.framework.AbstractMixRecommender;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Set;

@Service
public class CommonMixRecommender extends AbstractMixRecommender {

    @Autowired(required = false)
    public CommonMixRecommender(RedisSetAdapter redisSetAdapter,
                                RedisListAdapter redisListAdapter,
                                RedisStringAdapter redisStringAdapter,
                                MixedRecommendPoolMapper mixedRecommendPoolMapper) {
        super(1, 1);
        this.redisSetAdapter = redisSetAdapter;
        this.redisListAdapter = redisListAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
    }


    @Override
    protected List<MixRecomendResult> syncRecommend(Long userId, Integer actionType, Integer num, String areaCode,int platform) {
        // 已推荐redis key
        KeyGenerator recommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey(platform).appendKey(OperationLocationEnum.HOME_PAGE.getName()).appendKey("already");
        // 最后一次推荐记录的权重
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey(platform).appendKey(OperationLocationEnum.HOME_PAGE.getName()).appendKey("last");

        List<MixRecomendResult> result = Lists.newArrayList();

        // 已推荐记录
        Set<Long> recommendedIds = Sets.newHashSet();
        // 上一次推荐的最后一条权重值
        Integer lastRecommendedWeight = null;

        if (AppConstant.ACTION_TYPE_DOWN == actionType) {
            redisStringAdapter.remove(recommendedKey);
            redisStringAdapter.remove(lastRecommendedKey);
        } else {
            // 获取 redis 缓存
            recommendedIds = redisSetAdapter.getAllMembers(recommendedKey, Long.class);
            lastRecommendedWeight = redisStringAdapter.getInt(lastRecommendedKey);
        }

        List<MixRecomendResult> originList = mixedRecommendPoolMapper.selectLastRecommendList(lastRecommendedWeight, areaCode, 100,recommendedIds);

        this.recommendedFilter(originList, result, recommendedKey, lastRecommendedKey, recommendedIds, num);
        return result;
    }


    /**
     * 过滤已阅读的
     *
     * @param originList
     * @param resultList
     * @param recommendedKey
     * @param lastRecommendedKey
     * @param record
     * @param num
     */
    private void recommendedFilter(List<MixRecomendResult> originList,
                                   List<MixRecomendResult> resultList,
                                   KeyGenerator recommendedKey,
                                   KeyGenerator lastRecommendedKey,
                                   Set<Long> record,
                                   int num) {

        for (MixRecomendResult mixRecomendResult : originList) {
            //5.初始判断是否与之前的最新推荐池id或者本次的固定推荐池id重复，如果不重复则将其加入结果，并加入临时推荐记录做去重准备
            this.generateResult(record, mixRecomendResult, resultList);

            //6.一旦数量达标，则退出循环
            if (resultList.size() >= num) {
                logger.info("[recommendedFilter]已取得{}条混合推荐数据，功成圆满", num);
                break;
            }

        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            redisSetAdapter.add(recommendedKey, resultList.stream().map(MixRecomendResult::getId).toArray(Long[]::new));
            redisSetAdapter.expire(recommendedKey, NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);

            redisStringAdapter.set(lastRecommendedKey, resultList.get(resultList.size() - 1).getWeight());
            redisStringAdapter.expire(lastRecommendedKey, NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
        }

    }

    private void generateResult(Set<Long> record, MixRecomendResult mixRecomendResult, List<MixRecomendResult> resultList) {
        if (!record.contains(mixRecomendResult.getId())) {
            MixRecomendResult mixRecomendResultCopy = new MixRecomendResult(mixRecomendResult.getId(), mixRecomendResult.getOrigin(),mixRecomendResult.getWeight());
            resultList.add(mixRecomendResultCopy);
            record.add(mixRecomendResultCopy.getId());
        }
    }

}
