package com.bxm.newidea.recommend.handler.mix;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.AppConstant;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.recommend.framework.AbstractMixRecommender;
import com.bxm.newidea.service.MixRecommendService;
import com.bxm.newidea.vo.CircleNode;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import static com.bxm.newidea.constant.AppConstant.FIX_POOL_SIZE;

@Service
@Deprecated
public class FixMixRecommender extends AbstractMixRecommender {

    private MixRecommendService mixRecommendService;

    @Autowired(required = false)
    public FixMixRecommender(RedisSetAdapter redisSetAdapter,
                                 RedisListAdapter redisListAdapter,
                                 RedisStringAdapter redisStringAdapter,
                                 MixedRecommendPoolMapper mixedRecommendPoolMapper,
                                 MixRecommendService mixRecommendService
    ) {
        super(1, 2);
        this.redisSetAdapter = redisSetAdapter;
        this.redisListAdapter = redisListAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.mixRecommendService = mixRecommendService;
    }

    @Override
    protected List<MixRecomendResult> syncRecommend(Long userId, Integer actionType, Integer num, String areaCode,int platform) {
        long begin = System.currentTimeMillis();

        KeyGenerator mixRecordKey = RedisKeyConstant.MIX_RECOMMENDED.copy().appendKey(userId);
        KeyGenerator indexKey =RedisKeyConstant.MIX_FIX_INDEX.copy().appendKey(userId);
        KeyGenerator userCacheKey = RedisKeyConstant.MIX_LAST_READ_TIME.copy().appendKey(userId);

        List<MixRecomendResult> resultList = new ArrayList<>();

        //1.获得固定池的游标
        int index = getInitIndex(userId,indexKey, userCacheKey);
        logger.info("[syncRecommend]固定推荐池游标：{}", index);

        //2.获得固定池数据
        CircleNode[] mixRecommendResultArray = this.getData(areaCode);

        logger.info("[syncRecommendPost]固定推荐库容量：{}", mixRecommendResultArray!=null?mixRecommendResultArray.length:0);
        if (mixRecommendResultArray == null || mixRecommendResultArray.length==0) {
            return resultList;
        }

        //3.进行遍历筛选
        recommendedFilter(mixRecommendResultArray, mixRecordKey,indexKey, index, num, actionType, resultList,userId,platform);

        logger.debug("同步推荐耗时：{}", System.currentTimeMillis() - begin);
        return resultList;
    }

    private CircleNode[] getData(String areaCode){
        CircleNode[] mixRecommendResultArray = mixRecommendResults.get(areaCode);
        if (mixRecommendResultArray == null || mixRecommendResultArray.length == 0) {
            List<MixRecomendResult> mixRecommendResultList = mixedRecommendPoolMapper.selectFixRecommendList(FIX_POOL_SIZE, areaCode);
            if (CollectionUtils.isNotEmpty(mixRecommendResultList)) {
                mixRecommendResultArray = mixRecommendService.getCircleNode(mixRecommendResultList);
                mixRecommendResults.put(areaCode, mixRecommendResultArray);
            }
        }
        return mixRecommendResultArray;
    }

    /**
     * 得到用户的游标，也就是上一次的阅读记录
     * @param userId 用户id
     * @return
     */
    private int getInitIndex(Long userId,KeyGenerator indexCacheKey,KeyGenerator userCacheKey) {
        int index;
        if (redisStringAdapter.getString(userCacheKey).isEmpty()) {
            //如果用户没有最后的阅读时间记录，则说明用户没有看过首页的东西，直接按index为0来处理，从头看起
            index = 0;
        } else {
            index = redisStringAdapter.getInt(indexCacheKey);
        }
        return index;
    }

    /**
     * 下拉刷新
     * 下拉刷新时，会清空之前的推荐记录，并且循环取数据
     * @param circleNodes 循环数组
     * @param resultList 结果集
     * @param mixRecordKey 用户短期推荐记录
     * @param fromIndex 起始游标
     * @param num 本次推荐的数量
     * @param userId 用户id
     */
    private void doDownRefresh(CircleNode[] circleNodes,
                               List<MixRecomendResult> resultList,
                               KeyGenerator mixRecordKey,
                               KeyGenerator indexKey,
                               Integer fromIndex,
                               Integer num,
                               Long userId,int platform) {

        //1.获得循环数组总量看，也就是最大循环次数
        int total = circleNodes.length;

        //2.当用户切换地区时，需要清空混合推荐用户缓存，当其中逻辑失败时，需要在这里做二次保险
        if (fromIndex >= total) {
            fromIndex = 0;
            this.mixRecommendService.cleanMixCache(userId,platform);
        }

        //3.设置循环指针下标位置
        int next = fromIndex;
        Set<Long> record = redisSetAdapter.getAllMembers(mixRecordKey,Long.class);
        for (int i = 0; i < total; i++) {

            //4.取得当前游标的值
            CircleNode circleNode = circleNodes[next];

            //5.初始判断是否与之前的最新推荐池id或者本次的固定推荐池id重复，如果不重复则将其加入结果，并加入临时推荐记录做去重准备
            this.generateResult(record,mixRecordKey,circleNode,resultList);

            //7.如果没有达到数量上的要求,则继续循环，需要设置下一次的循环指针下标，如果当前在池底，则next指向0
            next = circleNode.getNext();

            //6.一旦数量达标，则退出循环
            if (resultList.size()>=num) {
                logger.info("[doDownRefresh]已取得{}条混合推荐数据，功成圆满,游标：{}",num,next);
                break;
            }


        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            redisSetAdapter.add(mixRecordKey, resultList.stream().map(MixRecomendResult::getId).toArray(Long[]::new));
            redisSetAdapter.expire(mixRecordKey, NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
            redisStringAdapter.set(indexKey, next, NewsCacheThresholdConfig.MIX_EXPIRE_FIX_INDEX);
        }
        logger.info("[doDownRefresh]结束遍历,数量：{},游标：{}",resultList.size(),next);
    }

    /**
     * 上划刷新
     * @param circleNodes 循环数组
     * @param resultList 结果集
     * @param mixRecordKey 用户短期推荐记录
     * @param fromIndex 起始游标
     * @param num 本次推荐的数量
     * @param userId 用户id
     */
    private void doUpRefresh(CircleNode[] circleNodes,
                             List<MixRecomendResult> resultList,
                             KeyGenerator mixRecordKey,
                             KeyGenerator indexKey,
                             int fromIndex,
                             int num,
                             Long userId,int platform) {

        //1.获得循环数组总量看，也就是最大循环次数
        int total = circleNodes.length;

        //2.当用户切换地区时，需要清空混合推荐用户缓存，当其中逻辑失败时，需要在这里做二次保险
        if (fromIndex >= total) {
            fromIndex = 0;
            mixRecommendService.cleanMixCache(userId,platform);
        }

        //3.设置循环指针下标位置
        int next = fromIndex;
        Set<Long> record = redisSetAdapter.getAllMembers(mixRecordKey,Long.class);
        for (int i = 0; i < total; i++) {

            //4.取得当前游标的值
            CircleNode circleNode = circleNodes[next];

            //5.初始判断是否与之前的最新推荐池id或者本次的固定推荐池id重复，如果不重复则将其加入结果，并加入临时推荐记录做去重准备
            this.generateResult(record,mixRecordKey,circleNode,resultList);

            //7.如果没有达到数量上的要求,则继续循环，需要设置下一次的循环指针下标，如果当前在池底，则next指向0
            next = circleNode.getNext();

            //6.一旦数量达标，则退出循环
            if (resultList.size()>=num) {
                logger.info("[doUpRefresh]已取得{}条混合推荐数据，功成圆满",num);
                break;
            }

        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            redisSetAdapter.add(mixRecordKey, resultList.stream().map(MixRecomendResult::getId).toArray(Long[]::new));
            redisSetAdapter.expire(mixRecordKey, NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
        }

        if (next == fromIndex) {
            redisStringAdapter.set(indexKey, 0, NewsCacheThresholdConfig.MIX_EXPIRE_FIX_INDEX);
        } else {
            redisStringAdapter.set(indexKey, next, NewsCacheThresholdConfig.MIX_EXPIRE_FIX_INDEX);
        }
        logger.info("[doUpRefresh]结束遍历,数量：{}",resultList.size());
    }

    /**
     * 判断是否已被推荐过，如果没有则加入结果集并加入推荐记录
     *
     * @param mixRecordKey          推荐记录key
     * @param mixRecordKey 当前的数据
     * @param resultList            结果集
     */
    private void generateResult(Set<Long> record,KeyGenerator mixRecordKey, CircleNode circleNode, List<MixRecomendResult> resultList) {
        if (!record.contains(circleNode.getId())) {
            MixRecomendResult mixRecomendResult = new MixRecomendResult(circleNode.getId(), circleNode.getOrigin());
            resultList.add(mixRecomendResult);
            record.add(circleNode.getId());

        }
    }

    /**
     * 去重（固定推荐库）
     *
     * @param fromIndex              开始索引
     * @param num                    本次数量
     * @param actionType             动作 ，下拉还是上滑
     * @param resultList             结果数据
     * @param userId                 用户id
     */
    protected void recommendedFilter(CircleNode[] circleNodes,
                                     KeyGenerator mixRecordKey,
                                     KeyGenerator indexKey,
                                     Integer fromIndex,
                                     Integer num,
                                     Integer actionType,
                                     List<MixRecomendResult> resultList,
                                     Long userId,int platform) {
        if (actionType.equals(AppConstant.ACTION_TYPE_DOWN)) {
            doDownRefresh(circleNodes,resultList, mixRecordKey,indexKey, fromIndex, num, userId,platform);
        } else if (actionType.equals(AppConstant.ACTION_TYPE_UP)) {
            doUpRefresh(circleNodes,resultList,mixRecordKey,indexKey, fromIndex, num, userId,platform);
        }
    }


}
