package com.bxm.newidea.recommend.handler.mix;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.AppConstant;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.recommend.framework.AbstractMixRecommender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

@Service
@Deprecated
public class RecentlyMixRecommender extends AbstractMixRecommender {

    @Autowired(required = false)
    public RecentlyMixRecommender(RedisSetAdapter redisSetAdapter,
                                  RedisListAdapter redisListAdapter,
                                  RedisStringAdapter redisStringAdapter,
                                  MixedRecommendPoolMapper mixedRecommendPoolMapper) {
        super(1, 1);
        this.redisSetAdapter = redisSetAdapter;
        this.redisListAdapter = redisListAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
    }

    @Override
    protected List<MixRecomendResult> syncRecommend(Long userId, Integer actionType, Integer num, String areaCode,int platform) {
        long begin = System.currentTimeMillis();

        //1.上划不走最新推荐池
        if (AppConstant.ACTION_TYPE_UP == actionType) {
            return new ArrayList<>();
        }

        KeyGenerator mixRecordKey = RedisKeyConstant.MIX_RECOMMENDED.copy().appendKey(userId);
        KeyGenerator mixRecentlyPoolKey = RedisKeyConstant.MIX_RECENTLY_POOL.copy().appendKey(userId);
        KeyGenerator lastReadTimeKey = RedisKeyConstant.MIX_LAST_READ_TIME.copy().appendKey(userId);

        List<MixRecomendResult> resultList = new ArrayList<>();

        //2.下拉清空缓存池，保证下拉一定能取得数据
        this.redisSetAdapter.remove(mixRecordKey);

        //3.如果用户没有最后的阅读时间记录，则说明用户没有看过首页的东西，那么用户直接去固定的新闻池读数据即可（固定新闻池每5分钟更新一次）
        //  如果用户存在最后的阅读时间记录，则去redis中查看是否存在最新推荐池，如果为空，则补充
        Date lastReadTime = redisStringAdapter.get(lastReadTimeKey, Date.class);
        if (null == lastReadTime) {
            return resultList;
        } else {
            long size = fillMixRecentlyPool(mixRecentlyPoolKey, lastReadTime, areaCode);
            if (size == 0) {
                return resultList;
            }
        }

        //4.对最新推荐池进行筛选
        this.recommendedFilter(mixRecentlyPoolKey, mixRecordKey, num, resultList);
        logger.debug("同步推荐耗时：{}", System.currentTimeMillis() - begin);
        return resultList;
    }

    /**
     * 当发现最新推荐池为空的时候，填充最新推荐池
     *
     * @param mixRecentlyPoolKey 最新推荐池的key
     * @param lastReadTime       最后阅读时间
     * @param areaCode           地区编码
     * @return 填充的数量
     */
    private long fillMixRecentlyPool(KeyGenerator mixRecentlyPoolKey, Date lastReadTime, String areaCode) {
        long size = redisListAdapter.size(mixRecentlyPoolKey);
        if (size == 0) {
            //如果最新推荐是池的数量为0，则去拉去一批新的
            List<MixRecomendResult> mixRecommendResultList = mixedRecommendPoolMapper.selectRecentlyRecommendList(lastReadTime, areaCode);
            size = mixRecommendResultList.size();
            if (size != 0) {
                redisListAdapter.rightPush(mixRecentlyPoolKey, mixRecommendResultList.toArray(new MixRecomendResult[0]));
                redisListAdapter.expire(mixRecentlyPoolKey, NewsCacheThresholdConfig.MIX_EXPIRE_RECENTLY_POOL);
            }
        }
        return size;
    }

    /**
     * 对最新推荐池中的数据进行筛选
     *
     * @param mixRecentlyPoolKey redis中的最新推荐池key
     * @param mixRecordKey       redis中的推荐记录
     * @param num                数量
     * @param resultList         结果
     */
    protected void recommendedFilter(KeyGenerator mixRecentlyPoolKey,
                                     KeyGenerator mixRecordKey,
                                     Integer num,
                                     List<MixRecomendResult> resultList) {
        long begin = System.currentTimeMillis();

        //1.去往最新推荐池中去取得最新推荐池的容量
        long total = redisListAdapter.size(mixRecentlyPoolKey);
        logger.debug("[recentlyRecommendedFilter]redis拉取列表耗时：{} 列表长：{}", System.currentTimeMillis() - begin, total);

        //2.之前已经判断过这个最新推荐池是否已经是空了，并且是空的话会补充，所以这里如果判断是空的话，说明确实没有最新的数据了
        if (0 == total) {
            return;
        }

        List<MixRecomendResult> mixRecomendResultList = redisListAdapter.leftIndex(mixRecentlyPoolKey,total,MixRecomendResult.class);

        //3.遍历最新推荐池
        Set<Long> record = redisSetAdapter.getAllMembers(mixRecordKey,Long.class);
        int i = 0;
        for (MixRecomendResult mixRecentlyPoolResult:mixRecomendResultList) {

            if (mixRecentlyPoolResult == null) {
                continue;
            }

            //4.判断是否已被推荐过，如果没有则加入结果集并加入推荐记录
            this.generateResult(record, mixRecentlyPoolResult, resultList);

            i=i+1;
            //5.一旦数量达标，则退出循环
            if (resultList.size() >= num) {
                logger.info("[recentlyRecommendedFilter]已取得{}条最新混合推荐数据，功成圆满", num);
                break;
            }

        }
        redisListAdapter.leftTrim(mixRecentlyPoolKey, i, total);
        if (!CollectionUtils.isEmpty(resultList)) {
            redisSetAdapter.add(mixRecordKey, resultList.stream().map(MixRecomendResult::getId).toArray(Long[]::new));
            redisSetAdapter.expire(mixRecordKey, NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
        }

        logger.info("[recentlyRecommendedFilter]bloom去重耗时：{}", System.currentTimeMillis() - begin);
    }

    /**
     * 判断是否已被推荐过，如果没有则加入结果集并加入推荐记录
     *
     * @param record          推荐记录key
     * @param mixRecentlyPoolResult 当前的数据
     * @param resultList            结果集
     */
    private void generateResult(Set<Long> record, MixRecomendResult mixRecentlyPoolResult, List<MixRecomendResult> resultList) {
        if (!record.contains(mixRecentlyPoolResult.getId())) {
            MixRecomendResult mixRecomendResult = new MixRecomendResult(mixRecentlyPoolResult.getId(), mixRecentlyPoolResult.getOrigin());
            resultList.add(mixRecomendResult);
            record.add(mixRecentlyPoolResult.getId());
        }
    }
}
