package com.bxm.newidea.recommend.handler.news;


import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.domain.NewsPoolMapper;
import com.bxm.newidea.enums.NewsKindEnum;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.recommend.framework.AbstractNewsRecommender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 应急推荐策略 缓存过期或者各种策略都无结果时使用
 */
@Component
public class EmergencyNewsRecommender extends AbstractNewsRecommender {

    private NewsPoolMapper newsPoolMapper;

    @Autowired(required = false)
    public EmergencyNewsRecommender(NewsPoolMapper newsPoolMapper,
                                    RedisListAdapter redisListAdapter,
                                    NewsSyncIntegrationService newsSyncIntegrationService) {
        super(1,99);
        this.newsPoolMapper = newsPoolMapper;
        this.redisListAdapter = redisListAdapter;
        this.newsSyncIntegrationService = newsSyncIntegrationService;
    }

    @Override
    protected List<Long> syncRecommend(Long userId, Integer kindId, Integer num, String areaCode) {
        List<Long> result = new ArrayList<>();

        //1.在数据库中取得未推荐过的数据
        List<Long> originList =listEmergencyNews(userId,kindId,num);
        //2.进行去重处理
        if (!CollectionUtils.isEmpty(originList)) {
            recommendedFilter(originList, num, result, userId);
        }

        return result;
    }

    private List<Long> listEmergencyNews(Long userId,Integer kindId,Integer num){
        List<Long> originList;
        if (kindId==null) {
            originList = newsPoolMapper.recommendNews(userId, Long.valueOf(NewsKindEnum.RECOMMEND.getCode()),1,null,num+5);
        } else {
            originList = newsPoolMapper.recommendNews(userId, Long.valueOf(kindId), 1, null, num+5);
        }
        return originList;
    }

    @Override
    protected void asyncRecommend(Long userId, Integer kindId, String areaCode) {
        //nothing to do
    }
}
