package com.bxm.newidea.recommend.handler.news;

import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.domain.HotnewsRecommendedMapper;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.recommend.framework.AbstractNewsRecommender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author leon 2019年1月24日 上午10:49:02
 * @ClassName HotNewsRecommender.java
 * @Description 功能描述： 热门新闻推荐策略
 * @CopyRight 杭州微财网络科技有限公司
 */
@Component
public class HotNewsRecommender extends AbstractNewsRecommender {

    private HotnewsRecommendedMapper hotnewsRecommendedMapper;

    @Autowired(required = false)
    public HotNewsRecommender(RedisListAdapter redisListAdapter,
                              HotnewsRecommendedMapper hotnewsRecommendedMapper,
                              NewsSyncIntegrationService newsSyncIntegrationService) {
        super(0.2, 0);
        this.redisListAdapter = redisListAdapter;
        this.hotnewsRecommendedMapper = hotnewsRecommendedMapper;
        this.newsSyncIntegrationService = newsSyncIntegrationService;
    }

    @Override
    protected List<Long> syncRecommend(Long userId, Integer kindId, Integer num, String areaCode) {
        List<Long> result = new ArrayList<>();

        //1.取得数据
        List<Long> originList = hotnewsRecommendedMapper.recommendHotNews(num+2, userId, areaCode);

        //2.去重过滤
        if (!CollectionUtils.isEmpty(originList)) {
            recommendedFilter(originList,num,result,userId);
        }

        return result;
    }



    @Override
    protected void asyncRecommend(Long userId, Integer kindId, String areaCode) {

    }
}
