package com.bxm.newidea.recommend.handler.news;

import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.domain.LocalnewsRecommendedMapper;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.enums.NewsKindEnum;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.recommend.framework.AbstractNewsRecommender;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 本地新闻策略
 */
@Component
public class LocalNewsRecommender extends AbstractNewsRecommender {

    private NewsMapper newsMapper;

    private LocalnewsRecommendedMapper localnewsRecommendedMapper;

    @Autowired(required = false)
    public LocalNewsRecommender(NewsMapper newsMapper, RedisListAdapter redisListAdapter,
                                LocalnewsRecommendedMapper localnewsRecommendedMapper,
                                NewsSyncIntegrationService newsSyncIntegrationService) {
        super(0.1d, 2);
        this.newsMapper = newsMapper;
        this.redisListAdapter = redisListAdapter;
        this.localnewsRecommendedMapper = localnewsRecommendedMapper;
        this.newsSyncIntegrationService = newsSyncIntegrationService;
    }

    @Override
    protected List<Long> syncRecommend(Long userId, Integer kindId, Integer num, String areaCode) {
        if (StringUtils.isEmpty(areaCode)) {
            return new ArrayList<>();
        }
        Long province = Long.valueOf(areaCode.substring(0, 2));

        //1.取得数据
        List<Long> originList = listLocalnews(userId, kindId, num, province, areaCode);

        List<Long> result = new ArrayList<>();
        //2.去重过滤
        if (!CollectionUtils.isEmpty(originList)) {
            recommendedFilter(originList, num, result, userId);
        }
        return result;
    }

    private List<Long> listLocalnews(Long userId, Integer kindId, Integer num, Long province, String areaCode) {
        List<Long> originList = new ArrayList<>();
        if (kindId != null) {
            //1.本地新闻推荐（废弃）
            if (kindId.intValue() == NewsKindEnum.LOCAL.getCode().intValue()) {
                originList = localnewsRecommendedMapper.recommendLocalnews(userId, areaCode, province, num);
            }
        } else {
            //2.首页本地推荐,加5条防止重复
            originList = localnewsRecommendedMapper.recommendLocalnewsOfIndex(userId, areaCode, province, num + 5);
        }
        return originList;
    }


    @Override
    protected void asyncRecommend(Long userId, Integer kindId, String areaCode) {

    }
}
