package com.bxm.newidea.recommend.handler.video;

import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.domain.VideoMapper;
import com.bxm.newidea.domain.VideoRecommendMapper;
import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.recommend.framework.AbstractVideoRecommender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
@Component
public class EmergencyVideoRecommender extends AbstractVideoRecommender {

    private VideoMapper videoMapper;

    @Autowired(required = false)
    public EmergencyVideoRecommender(RedisListAdapter redisListAdapter, VideoRecommendMapper videoRecommendMapper, VideoMapper videoMapper) {
        super(0.0,1);
        this.redisListAdapter = redisListAdapter;
        this.videoRecommendMapper = videoRecommendMapper;
        this.videoMapper = videoMapper;

    }

    @Override
    protected List<VideoDto> syncRecommend(Long userId, Integer num) {
        return  videoMapper.getPublicVideo(userId,num);
    }

    @Override
    protected void asyncRecommend(Long userId) {

    }
}
