package com.bxm.newidea.service;

import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.vo.CircleNode;

import java.util.List;

/**
 * <p>
 *     论坛相关服务接口
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/3
 */
public interface ForumService {
    
    /**
     * 论坛数据推荐
     * @date: 2019/4/3
     * @param forumParam 用户id
     * @return java.util.List<java.lang.Long>
     * @throws 
     */
    List<Long> recommend(ForumParam forumParam);

    /**
     * 清除用户置顶的帖子记录
     * @param userId
     * @param postId
     */
    void cleanUserTop(Long userId,Long postId);

    /**
     * 将数据转换为循环数组
     * @param idList
     * @return
     */
    CircleNode[] getCircleNode(List<Long> idList);

}
