package com.bxm.newidea.service;

import com.bxm.newidea.dto.VideoDto;


import java.util.List;

public interface RecommendService {

      /**
       * 新闻推荐
       * @param userId
       * @param kindId
       * @param pageSize
       * @param areaCode
       * @param curPage
       * @return
       */
      List<Long> recommend(Long userId, Integer kindId,Integer pageSize, String areaCode,Integer curPage);

      /**
       * 新闻详情推荐
       * @param userId
       * @param newsId
       * @param size
       * @return
       */
      List<Long> recommendByNewsDetail(Long userId,Long newsId,Integer size,Integer platform);

      /**
       * 小视频推荐
       * @param userId
       * @param pageSize
       * @return
       */
      List<VideoDto> recommend(Long userId,Integer pageSize);


}
