package com.bxm.newidea.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.constant.AppConstant;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.recommend.engine.ForumRecommendEngine;
import com.bxm.newidea.service.ForumService;
import com.bxm.newidea.vo.CircleNode;
import com.bxm.newidea.vo.ForumTopPost;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *     论坛推荐服务接口实现
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/3
 */
@Service
public class ForumServiceImpl extends BaseService implements ForumService {
    private static final Logger LOG = LoggerFactory.getLogger(ForumServiceImpl.class);
    @Autowired
    private ForumRecommendEngine forumRecommendEngine;

    @Autowired
    private RedisListAdapter redisListAdapter;

    @Override
    public List<Long> recommend(ForumParam forumParam) {
        String msg = checkParam(forumParam);
        if(StringUtils.isNotBlank(msg)){
            LOG.error("[forum recommend service] parameter error:[{}],参数:[{}]",msg,JSONObject.toJSONString(forumParam));
            return new ArrayList<Long>();
        }
        if(null == forumParam.getPageSize()){
            forumParam.setPageSize(AppConstant.FORUM_LIST_PAGE);
        }
        return forumRecommendEngine.recommend(forumParam);
    }

    @Override
    public void cleanUserTop(Long userId,Long postId) {
//        if (null == userId) {
//            return;
//        }
//        KeyGenerator postUserTop = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey("top");
//
//        Long size = redisListAdapter.size(postUserTop);
//        if (size == 0) {
//            return;
//        }
//        //得到该用户在一个小时内发的帖子
//        List<ForumTopPost> forumTopPostList = redisListAdapter.leftIndex(postUserTop, size - 1, ForumTopPost.class);
//        logger.debug("[cleanUserTop] 得到用户在一个小时以内发的帖子:{}", JSONObject.toJSONString(forumTopPostList));
//
//        //如果帖子中，有被审核拒绝的就删除
//        forumTopPostList.removeIf(e -> postId.equals(e.getId()));
//        redisListAdapter.remove(postUserTop);
//        logger.debug("[cleanUserTop] 取消用户被审核拒绝的帖子置顶:{}", JSONObject.toJSONString(forumTopPostList));
//
//        //把不符合去除条件的重新加回去
//        redisListAdapter.rightPush(postUserTop, forumTopPostList.toArray(new ForumTopPost[0]));
    }

    @Override
    public CircleNode[] getCircleNode(List<Long> idList) {
        int length = idList.size();
        CircleNode[] circleNodes = new CircleNode[length];
        int i =0;
        for (Long id : idList) {
            circleNodes[i] = new CircleNode();
            circleNodes[i].setId(id);
            circleNodes[i].setNext(i+1);
            i++;
        }
        circleNodes[length-1].setNext(0);
        return circleNodes;
    }

    /**
     * 参数校验
     * @date: 2019/4/3
     * @param forumParam
     * @return java.lang.String
     * @throws 
     */
    private String checkParam(ForumParam forumParam) {
        Integer operationId = forumParam.getOperationId();
        StringBuffer sb = new StringBuffer();
        if(null == forumParam.getUserId()){
            sb.append("用户id为空").append(",");
        }
        if(null == operationId){
            sb.append("运营位id为空").append(",");
        }
        if(StringUtils.isBlank(forumParam.getAreaCode())){
            sb.append("区域编码为空").append(",");
        }
        if(null != operationId && OperationLocationEnum.FORUM_POST_DETAIL.getCode() == operationId){
            if (null == forumParam.getPostId()) {
                sb.append("帖子id为空").append(",");
            }
        } else {
            if (null == forumParam.getActionType()) {
                sb.append("行为标记为空").append(",");
            }
            if (null != operationId && null == forumParam.getForumId() &&
                    (OperationLocationEnum.FORUM_PLATE_ELITE.getCode() == operationId ||
                            OperationLocationEnum.FORUM_PLATE_NEWEST.getCode() == operationId)) {
                sb.append("板块id为空").append(",");
            }
            if (null != operationId && null == forumParam.getTopicId() &&
                    (OperationLocationEnum.FORUM_TOPIC_HOT.getCode() == operationId ||
                            OperationLocationEnum.FORUM_TOPIC_NEWEST.getCode() == operationId)) {
                sb.append("话题id为空").append(",");
            }
        }
        if(sb.length() > 0){
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

}
