package com.bxm.newidea.service.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.ForumPostMapper;
import com.bxm.newidea.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.MixQueryParam;
import com.bxm.newidea.service.MixRecommendService;
import com.bxm.newidea.vo.*;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

@Service
public class MixRecommendServiceImpl extends BaseService implements MixRecommendService {

    @Autowired
    private RedisListAdapter redisListAdapter;

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Override
    public void cleanMixCache(Long userId,Integer platform){
        logger.debug("[cleanMixCache]删除混合推荐缓存，用户id:[{}],平台:[{}]",userId,platform);
        // 已推荐redis key
        KeyGenerator mixRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey(platform).appendKey(OperationLocationEnum.HOME_PAGE.getName()).appendKey("already");
        // 最后一次推荐记录的权重
        KeyGenerator mixLastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey(platform).appendKey(OperationLocationEnum.HOME_PAGE.getName()).appendKey("last");
        //
        KeyGenerator mixLastReadTimeKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey(platform).appendKey(OperationLocationEnum.HOME_PAGE.getName()).appendKey("lastreadtime");

        // 已推荐redis key
        KeyGenerator recommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey(platform).appendKey(OperationLocationEnum.FORUM_HOME_PAGE.getName()).appendKey("already");
        // 最后一次推荐记录
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey(platform).appendKey(OperationLocationEnum.FORUM_HOME_PAGE.getName()).appendKey("last");

        redisSetAdapter.remove(recommendedKey);
        redisStringAdapter.remove(lastRecommendedKey);

        redisStringAdapter.remove(mixRecommendedKey);
        redisListAdapter.remove(mixLastRecommendedKey);
        redisListAdapter.remove(mixLastReadTimeKey);
    }

    @Override
    public CircleNode[] getCircleNode(List<MixRecomendResult> mixRecommendResultList) {
        int length = mixRecommendResultList.size();
        CircleNode[] circleNodes = new CircleNode[length];
        int i =0;
        for (MixRecomendResult mixRecomendResult : mixRecommendResultList) {
            circleNodes[i] = new CircleNode();
            circleNodes[i].setId(mixRecomendResult.getId());
            circleNodes[i].setOrigin(mixRecomendResult.getOrigin());
            circleNodes[i].setNext(i+1);
            i++;
        }
        circleNodes[length-1].setNext(0);
        return circleNodes;
    }


}
