package com.bxm.newidea.util;

import org.apache.commons.lang3.StringUtils;

/**
 * <p></p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/18
 */
public class ObjectUtil {
    
    /**
     * 转成 Integer
     * @date: 2019/4/18
     * @param obj
     * @return java.lang.Integer
     * @throws 
     */
    public static Integer displayToInteger(Object obj){
        if (null == obj){
            return null;
        }
        if (obj instanceof Integer){
            return (Integer) obj;
        } if (obj instanceof Long){
            return ((Long)obj).intValue();
        } if(obj instanceof Double){
            return ((Double)obj).intValue();
        } if(obj instanceof Float){
            return ((Float)obj).intValue();
        } else {
            String str = String.valueOf(obj);
            if(StringUtils.isNumeric(str.trim())){
                return Integer.valueOf(str.trim());
            }
            return null;
        }
    }

    /**
     * 转成String
     * @date: 2019/4/18
     * @param obj
     * @return java.lang.String
     * @throws 
     */
    public static String displayToString(Object obj){
        if (null == obj) {
            return "";
        } else {
            String str = obj.toString();
            return null == str ? "" : str;
        }
    }

    /**
     * 转成 Long
     * @date: 2019/4/18
     * @param obj
     * @return java.lang.Long
     * @throws 
     */
    public static Long displayToLong(Object obj){
        if (null == obj) {
            return null;
        } if (obj instanceof Integer){
            return ((Integer) obj).longValue();
        } if (obj instanceof Long){
            return (Long)obj;
        } if(obj instanceof Double){
            return ((Double)obj).longValue();
        } if(obj instanceof Float){
            return ((Float)obj).longValue();
        } else {
            String str = String.valueOf(obj);
            if(StringUtils.isNumeric(str.trim())){
                return Long.valueOf(str.trim());
            }
            return null;
        }
    }
}
