//package com.bxm.localnews.service;
//
//import com.bxm.localnews.model.vo.Enterpriseextend;
//import com.bxm.localnews.utils.ChineseToPinYinUtil;
//import com.bxm.newidea.component.tools.StringUtils;
//import org.elasticsearch.index.query.DisMaxQueryBuilder;
//import org.elasticsearch.index.query.QueryBuilder;
//import org.elasticsearch.index.query.QueryBuilders;
//import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
//import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilders;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
//import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
//import org.springframework.data.elasticsearch.core.query.SearchQuery;
//import org.springframework.stereotype.Service;
//
//import java.util.List;
//
//import static org.elasticsearch.index.query.QueryBuilders.matchQuery;
//
//@Service
//public class SearchService {
//
//    @Autowired
//    private ElasticsearchTemplate elasticsearchTemplate;
//
//    /**
//     * 混合搜索
//     * @return
//     */
//    public List<Enterpriseextend> chineseWithEnglishOrPinyinSearch(String key) {
//
//        DisMaxQueryBuilder  disMaxQueryBuilder=QueryBuilders.disMaxQuery();
//
//        //是否有中文开头，有则返回中文前缀
//        String startChineseString=ChineseToPinYinUtil.getStartChineseString(key);
//
//        /**
//         * 源值搜索，不做拼音转换
//         * 权重* 1.5
//         */
//        QueryBuilder normSearchBuilder= matchQuery("entName.ngram",key).analyzer("ngramSearchAnalyzer").boost(5f);
//
//        /**
//         * 拼音简写搜索
//         * 1、分析key，转换为简写  case:  南京东路==>njdl，南京dl==>njdl，njdl==>njdl
//         * 2、搜索匹配，必须完整匹配简写词干
//         * 3、如果有中文前缀，则排序优先
//         * 权重*1
//         */
//        String analysisKey= ChineseToPinYinUtil.ToFirstChar(key);
//        QueryBuilder pingYinSampleQueryBuilder=QueryBuilders.termQuery("entName.SPY", analysisKey);
//
//        /**
//         * 拼音简写包含匹配，如 njdl可以查出 "城市公牛 南京东路店"，虽然非南京东路开头
//         * 权重*0.8
//         */
//        QueryBuilder  pingYinSampleContainQueryBuilder=null;
//        if(analysisKey.length()>1){
//            pingYinSampleContainQueryBuilder= QueryBuilders.wildcardQuery("entName.SPY", "*"+analysisKey+"*").boost(0.8f);
//        }
//
//        /**
//         * 拼音全拼搜索
//         * 1、分析key，获取拼音词干   case :  南京东路==>[nan,jing,dong,lu]，南京donglu==>[nan,jing,dong,lu]
//         * 2、搜索查询，必须匹配所有拼音词，如南京东路，则nan,jing,dong,lu四个词干必须完全匹配
//         * 3、如果有中文前缀，则排序优先
//         * 权重*1
//         */
//        QueryBuilder pingYinFullQueryBuilder=null;
//        if(key.length()>1){
//            pingYinFullQueryBuilder=QueryBuilders.matchPhraseQuery("entName.FPY",  ChineseToPinYinUtil.ToPinyin(key)).analyzer("pinyiFullSearchAnalyzer");
//        }
//
//        /**
//         * 完整包含关键字查询(优先级最低，只有以上四种方式查询无结果时才考虑）
//         * 权重*0.8
//         */
//        QueryBuilder containSearchBuilder= matchQuery("entName", key).analyzer("ikSearchAnalyzer").minimumShouldMatch("100%");
//
//        disMaxQueryBuilder
//                .add(normSearchBuilder)
//                .add(pingYinSampleQueryBuilder)
//                .add(containSearchBuilder);
//
//        //以下两个对性能有一定的影响，故作此判定，单个字符不执行此类搜索
//        if(pingYinFullQueryBuilder!=null){
//            disMaxQueryBuilder.add(pingYinFullQueryBuilder);
//        }
//        if(pingYinSampleContainQueryBuilder!=null){
//            disMaxQueryBuilder.add(pingYinSampleContainQueryBuilder);
//        }
//
//        QueryBuilder queryBuilder=disMaxQueryBuilder;
//
//        //关键如果有中文，则必须包含在内容中（这里把英文的过滤掉）
//        if(StringUtils.isNotBlank(startChineseString)){
//            queryBuilder=    QueryBuilders.boolQuery()
//                    .must(disMaxQueryBuilder)
//                    .filter(QueryBuilders.queryStringQuery("*"+startChineseString+"*").field("entName").analyzer("ngramSearchAnalyzer"));
//
//
//            FunctionScoreQueryBuilder.FilterFunctionBuilder[] filterFunctionBuilders = {
//                    new FunctionScoreQueryBuilder.FilterFunctionBuilder(
//                            matchQuery("entName",startChineseString).analyzer("ngramSearchAnalyzer"),
//                            ScoreFunctionBuilders.weightFactorFunction(1.5f)
//                    )
//            };
//
//            queryBuilder=QueryBuilders.functionScoreQuery(queryBuilder,filterFunctionBuilders);
//
//        }
//
//        SearchQuery searchQuery=new NativeSearchQueryBuilder().withQuery(queryBuilder).build();
//        System.out.println(searchQuery.getQuery());
//        return  elasticsearchTemplate.queryForList(searchQuery, Enterpriseextend.class);
//    }
//
//
//}
//
