package com.bxm.localnews.sync.vo.local;

import com.bxm.localnews.sync.vo.spider.BaseSyncBean;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class AdminNews extends BaseSyncBean {

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("频道id")
    private Integer kindId;

    @ApiModelProperty("频道名称")
    private String kindName;

    @ApiModelProperty("作者")
    private String author;

    @ApiModelProperty("来源")
    private String source;

    @ApiModelProperty("页面展示发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date issueTime;

    @ApiModelProperty("生效时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date publishTime;

    @ApiModelProperty("标签数组 0 1 2 4 99")
    private String showLevels;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("发布区域类型0全国 1地方")
    private Integer deliveryType;

    @ApiModelProperty("地区编码数组")
    private String areaDetail;

    @ApiModelProperty("封面图片")
    private String coverUrl;

    @ApiModelProperty("热门过期时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date hotExpireTime;

    @ApiModelProperty("置顶过期时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date topExpireTime;

    @ApiModelProperty("状态 0：待审核  1：已拒绝  2：已通过")
    private Byte reviewStatus;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date addTime;

    private String address;

    private Byte status;

    @ApiModelProperty("内容中图片列表")
    private String imgUrl;

    @ApiModelProperty("是否置顶 1：否 2：是")
    private Byte top;

    @ApiModelProperty("是否頻道置顶 1：否 2：是")
    private Byte kindTop;

    @ApiModelProperty("是否是热文 1：否  2：是")
    private Byte hot;

    @ApiModelProperty("是否强引导下载  0:否 1:是")
    private Byte isBootDownload;

    @ApiModelProperty("视频列表")
    private String videoList;

    @ApiModelProperty("编辑寄语")
    private String editorMessage;

    @ApiModelProperty("编辑寄语id")
    private Long editorMessageId;

    @ApiModelProperty("启用占位符")
    private Long enablePlaceholder;

    @ApiModelProperty("封面图片（json字符串格式）")
    private String coverList;

    @ApiModelProperty("封面选择")
    private Byte coverSelect;

    @ApiModelProperty("是否推荐")
    private Byte isRecommend;
}
