package com.bxm.localnews.sync.vo.local;

import com.bxm.localnews.sync.vo.spider.BaseSyncBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("新闻状态信息")
public class NewsStatus extends BaseSyncBean {

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("地区编码数组")
    private String areaDetail;

    @ApiModelProperty("状态 0：待审核  1：已拒绝  2：已通过")
    private Byte reviewStatus;

    @ApiModelProperty("状态 -2：已删除 -1：待发布 0:抓取中 1：可用  2：失效")
    private Byte status;

    @ApiModelProperty("是否置顶 1：否 2：是")
    private Byte top;

    @ApiModelProperty("是否是热文 1：否  2：是")
    private Byte hot;

    @ApiModelProperty("是否推荐 0:否  1是")
    private Byte isRecommend;

}
