package com.bxm.localnews.sync.vo.local;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel(description = "帖子实体")
public class ForumPost {

    @ApiModelProperty("帖子id")
    private Long id;

    @ApiModelProperty("话题")
    private ForumPostTopic forumPostTopic;

    @ApiModelProperty("帖子标题")
    private String title;

    @ApiModelProperty("帖子内容")
    private String content;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("帖子文本部分")
    private String textField;

    @ApiModelProperty("帖子图片（json字符串）")
    private String imgList;

    @ApiModelProperty("发帖用户所属区域")
    private String areaCode;

    @ApiModelProperty("发帖用户头像")
    private String userImg;

    @ApiModelProperty("发帖用户名称")
    private String userName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("发布时间（用于运营定时发布）")
    private Date publishTime;

    @ApiModelProperty("发布时间（用于客户端显示）")
    private Date displayTime;

    @ApiModelProperty("帖子状态(1:正常显示 2:审核中 3:审核拒绝 4:用户删除 5:仅楼主可见 6:本地圈屏蔽 7:运营删除)")
    private Byte status;

    @ApiModelProperty("发布区域类型 0:全国 1:区域")
    private Byte deliveryType;

    /**
     * 帖子评论
     */
    private List<NewsReply> replyList;

}
