package com.bxm.localnews.sync.vo.local;

import com.bxm.localnews.common.vo.INewsIdSharding;
import com.bxm.localnews.common.vo.IProvicneSharding;
import lombok.Data;

import java.util.Date;

@Data
public class NewsTag implements INewsIdSharding, IProvicneSharding {
    private Long id;

    /**
     * 新闻ID
     */
    private Long newsId;

    /**
     * 标签ID
     */
    private Long tagId;

    /**
     * 标签名称
     */
    private String name;

    /**
     * 标签权重
     */
    private Double weight;

    /**
     * 添加时间
     */
    private Date addTime;

    /**
     * 标签类型
     */
    private Byte tagType;

    private Long province;


    public Long getId() {
        return id;
    }

    public NewsTag setId(Long id) {
        this.id = id;
        return this;
    }

    public Long getNewsId() {
        return newsId;
    }

    public NewsTag setNewsId(Long newsId) {
        this.newsId = newsId;
        return this;
    }

    public Long getTagId() {
        return tagId;
    }

    public NewsTag setTagId(Long tagId) {
        this.tagId = tagId;
        return this;
    }

    public String getName() {
        return name;
    }

    public NewsTag setName(String name) {
        this.name = name;
        return this;
    }

    public Double getWeight() {
        return weight;
    }

    public NewsTag setWeight(Double weight) {
        this.weight = weight;
        return this;
    }

    public Date getAddTime() {
        return addTime;
    }

    public NewsTag setAddTime(Date addTime) {
        this.addTime = addTime;
        return this;
    }

    public Byte getTagType() {
        return tagType;
    }

    public NewsTag setTagType(Byte tagType) {
        this.tagType = tagType;
        return this;
    }

    public Long getProvince() {
        return province;
    }

    public NewsTag setProvince(Long province) {
        this.province = province;
        return this;
    }
}
