package com.bxm.localnews.sync.vo.spider;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Data
public class SpiderForumPost extends BaseSyncBean {
    /**
     * 主键
     */
    private Long id;
    /**
     * 用户id
     */
    private Long userId;
    /**
     * 用户头像
     */
    private String userImg;
    /**
     * 马甲号类型 1:评论马甲  2:发帖马甲 3:普通陪聊 4:地方大V 5:全国大V
     */
    private Integer userType;
    /**
     * 用户名称
     */
    private String name;
    /**
     * 话题id
     */
    private Long topicId;
    /**
     * 标题
     */
    private String title;
    /**
     * 内容
     */
    private String content;
    /**
     * 区域编码
     */
    private String areaCode;
    /**
     * 发布时间
     */
    private Date deployTime;
    /**
     * 评论列表
     */
    private List<SpiderForumPostComment> comments;

}
