package com.bxm.localnews.sync.vo.spider;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * <p>
 * 帖子评论表
 * </p>
 *
 * @author zhaoxin
 * @since 2019-11-11
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SpiderForumPostComment extends BaseSyncBean{
    /**
     * 主键
     */
    private Long id;
    /**
     * 帖子关联id
     */
    private Long sourceId;
    /**
     * 评论内容
     */
    private String content;
    /**
     * 用户id（虚拟用户中随机取）
     */
    private Long userId;
    /**
     * 用户昵称
     */
    private String name;
    /**
     * 用户头像
     */
    private String headImg;
    /**
     * 评论时间
     */
    private Date deployTime;
    /**
     * 上一级评论id
     */
    private Long parentId;
}
