package com.bxm.localnews.sync.vo.spider;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * coupon_goods
 * @author 
 */
public class SpiderCouponGoods extends BaseSyncBean {
    /**
     * 优惠券商品主键id
     */
    private Long id;

    /**
     * 商品id
     */
    private Long itemId;

    /**
     * 爬取的url(清洗干净)
     */
    private String goodsUrl;

    /**
     * 商品类目
     */
    private String category;

    /**
     * 商品标题
     */
    private String goodsTitle;

    /**
     * 商品原价
     */
    private BigDecimal originalPrice;

    /**
     * 商品日销量
     */
    private Integer daySales;

    /**
     * 商品总销量
     */
    private Integer totalSales;

    /**
     * 列表页缩略图（单）
     */
    private String listThumbnail;

    /**
     * 优惠券价格
     */
    private BigDecimal couponPrice;

    /**
     * 券后价
     */
    private BigDecimal couponAfterPrice;

    /**
     * 优惠券链接
     */
    private String couponUrl;

    /**
     * 商品推荐语
     */
    private String recommendWords;

    /**
     * 优惠券淘口令
     */
    private String taokouling;

    /**
     * 优惠券有效期起始时间
     */
    private Date effectiveStartTime;

    /**
     * 优惠券有效期结束时间
     */
    private Date effectiveEndTime;

    /**
     * 详情页主图（多）
     */
    private String detailHeadImgs;

    /**
     * 店铺头像
     */
    private String storeHeadImg;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 宝贝描述评分
     */
    private Double goodsScore;

    /**
     * 店铺服务评分
     */
    private Double sellerScore;

    /**
     * 物流服务评分
     */
    private Double logisticesScore;

    /**
     * 删除标记(0-无效 1-有效 2-待更新)
     */
    private Byte status;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 商品详情(包含原页面文本）
     */
    private String goodsDetail;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getGoodsUrl() {
        return goodsUrl;
    }

    public void setGoodsUrl(String goodsUrl) {
        this.goodsUrl = goodsUrl;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getGoodsTitle() {
        return goodsTitle;
    }

    public void setGoodsTitle(String goodsTitle) {
        this.goodsTitle = goodsTitle;
    }

    public BigDecimal getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(BigDecimal originalPrice) {
        this.originalPrice = originalPrice;
    }

    public Integer getDaySales() {
        return daySales;
    }

    public void setDaySales(Integer daySales) {
        this.daySales = daySales;
    }

    public Integer getTotalSales() {
        return totalSales;
    }

    public void setTotalSales(Integer totalSales) {
        this.totalSales = totalSales;
    }

    public String getListThumbnail() {
        return listThumbnail;
    }

    public void setListThumbnail(String listThumbnail) {
        this.listThumbnail = listThumbnail;
    }

    public BigDecimal getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(BigDecimal couponPrice) {
        this.couponPrice = couponPrice;
    }

    public BigDecimal getCouponAfterPrice() {
        return couponAfterPrice;
    }

    public void setCouponAfterPrice(BigDecimal couponAfterPrice) {
        this.couponAfterPrice = couponAfterPrice;
    }

    public String getCouponUrl() {
        return couponUrl;
    }

    public void setCouponUrl(String couponUrl) {
        this.couponUrl = couponUrl;
    }

    public String getRecommendWords() {
        return recommendWords;
    }

    public void setRecommendWords(String recommendWords) {
        this.recommendWords = recommendWords;
    }

    public String getTaokouling() {
        return taokouling;
    }

    public void setTaokouling(String taokouling) {
        this.taokouling = taokouling;
    }

    public Date getEffectiveStartTime() {
        return effectiveStartTime;
    }

    public void setEffectiveStartTime(Date effectiveStartTime) {
        this.effectiveStartTime = effectiveStartTime;
    }

    public Date getEffectiveEndTime() {
        return effectiveEndTime;
    }

    public void setEffectiveEndTime(Date effectiveEndTime) {
        this.effectiveEndTime = effectiveEndTime;
    }

    public String getDetailHeadImgs() {
        return detailHeadImgs;
    }

    public void setDetailHeadImgs(String detailHeadImgs) {
        this.detailHeadImgs = detailHeadImgs;
    }

    public String getStoreHeadImg() {
        return storeHeadImg;
    }

    public void setStoreHeadImg(String storeHeadImg) {
        this.storeHeadImg = storeHeadImg;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Double getGoodsScore() {
        return goodsScore;
    }

    public void setGoodsScore(Double goodsScore) {
        this.goodsScore = goodsScore;
    }

    public Double getSellerScore() {
        return sellerScore;
    }

    public void setSellerScore(Double sellerScore) {
        this.sellerScore = sellerScore;
    }

    public Double getLogisticesScore() {
        return logisticesScore;
    }

    public void setLogisticesScore(Double logisticesScore) {
        this.logisticesScore = logisticesScore;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getGoodsDetail() {
        return goodsDetail;
    }

    public void setGoodsDetail(String goodsDetail) {
        this.goodsDetail = goodsDetail;
    }
}