package com.bxm.localnews.sync.vo.spider;

import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
public class SpiderNews extends BaseSyncBean {
    /**
     * 主键id(每张表的尾数步长为10，与表名后缀对应)
     */
    private Long id;

    /**
     * 爬取的url(清洗干净)
     */
    private String url;

    /**
     * 图片链接，用;号隔开
     */
    private String imgUrl;

    /**
     * 标题 存储
     */
    private String title;

    /**
     * 新闻详情
     */
    private String content;

    /**
     * 导航(用|区分)
     */
    private String navigation;

    /**
     * 关键字
     */
    private String keyword;

    /**
     * 频道
     */
    private String channel;

    /**
     * 地区
     */
    private String region;

    /**
     * 新闻发布时间
     */
    private String deployTime;

    /**
     * 作者
     */
    private String author;

    /**
     * 来源
     */
    private String source;

    /**
     * 浏览器更新时间
     */
    private String lastModified;
}
