package com.bxm.localnews.sync.task;


import java.util.concurrent.CountDownLatch;

import javax.annotation.Resource;

import com.bxm.localnews.sync.thread.NewsSyncThread;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;

import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;


@Component
public class SyncNewsJob extends AbstractCustomJob {

    private static CountDownLatch countDownLatch = null;

    @Resource
    private AsyncTaskExecutor taskExecutor;

    /**
     * 分表总数
     */
    private int tableTotal = 10;

    public SyncNewsJob() {
        super("syncNews", "0 0/10 * * * ?", "新闻同步任务");
    }

    @Override
    public Message service() {
        this.logger.debug("sync news");
        if (countDownLatch == null || countDownLatch.getCount() == 0) {
            countDownLatch = new CountDownLatch(this.tableTotal);
            for (int i = 0; i < this.tableTotal; i++) {
                this.taskExecutor.execute(new NewsSyncThread().build(i, countDownLatch));
            }
        } else {
            this.logger.debug("上一次同步工作还没做完" + countDownLatch.getCount());
        }
        return Message.build();
    }

}
