package com.bxm.localnews.sync.thread;

import com.bxm.localnews.service.WechatNewsSyncService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 公众号信息同步
 */
public class WechatNewsSyncThread implements Runnable {

    private static final Logger logger = LoggerFactory.getLogger(WechatNewsSyncThread.class);

    public WechatNewsSyncThread build() {
        return this;
    }

    @Override
    public void run() {
        logger.debug("news_wechat thread:" + Thread.currentThread().getId() + "begin work");
        try {
            SpringContextHolder.getBean(WechatNewsSyncService.class).sync();
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        logger.debug("news_wechat thread:" + Thread.currentThread().getId() + "end work");
    }
}
