/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.sync.thread;

import com.bxm.localnews.service.NewsSyncService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewsSyncThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(NewsSyncThread.class);
    private NewsSyncService newsSyncService;
    private CountDownLatch countDownLatch;
    private Integer offset;

    public NewsSyncThread build(Integer offset, CountDownLatch countDownLatch) {
        this.newsSyncService = (NewsSyncService)SpringContextHolder.getApplicationContext().getBean(NewsSyncService.class);
        this.countDownLatch = countDownLatch;
        this.offset = offset;
        return this;
    }

    @Override
    public void run() {
        logger.debug("news thread:" + Thread.currentThread().getId() + "begin work");
        try {
            this.newsSyncService.sync(this.offset);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.countDownLatch.countDown();
        }
        logger.debug("news thread:" + Thread.currentThread().getId() + "end work");
    }
}

