package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.RecruitDTO;
import com.bxm.localnews.thirdparty.dto.UserInfoForJobDTO;
import com.bxm.localnews.thirdparty.service.BlueCollarService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.User;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * Created by Arei on 2018/10/16.
 */
@Api(tags = "3-09 蓝领相关接口", description = "提供蓝领相关接口操作")
@RestController
@RequestMapping("api/public/job")
public class BlueCollarController {

    private UserService userService;

    private BlueCollarService blueCollarService;

    @Autowired
    public BlueCollarController(UserService userService, BlueCollarService blueCollarService) {
        this.userService = userService;
        this.blueCollarService = blueCollarService;
    }

    @ApiOperation(value = "3-09-1 用户信息接口", notes = "提供用户信息,现阶段暂无ip相关数据，后续补上")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @GetMapping("/getUserInfo")
    public Json<UserInfoForJobDTO> getUserInfoByUserId(@RequestParam("userId") Long userId) {
        UserInfoForJobDTO userInfoForJobDTO = new UserInfoForJobDTO();
        User user = userService.selectByPrimaryKey(userId);
        BeanUtils.copyProperties(user, userInfoForJobDTO);
        return Json.build(userInfoForJobDTO).setCode(0);
    }

    @ApiOperation(value = "3-09-2 根据地区编码获取招聘列表", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区编码", paramType = "path", dataType = "String", required = true)
    })
    @GetMapping("/getRecruits/{areaCode}")
    public Json<RecruitDTO> getToolsByCode(@PathVariable String areaCode){
        return ResultUtil.genSuccessResult(this.blueCollarService.getRecruits(areaCode));
    }

}
