package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.thirdparty.param.BuryPointParam;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.log.LogMarker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 测试环境接收客户端和前端的埋点请求，记录到日志文件，方便测试
 * @author zhaoyadong 2018/11/6 17:24
 */
@Api(tags = "3-14 临时埋点", description = "埋点相关操作")
@RestController
@RequestMapping
public class BuryPointController extends BaseController {

    @ApiOperation(value = "记录埋点日志", notes = "记录埋点日志")
    @RequestMapping({"/point", "/dot/s.gif"})
    public void buryPoint(BuryPointParam buryPointParam) {
        logger.debug(LogMarker.BURY, buryPointParam.toString());
    }
}
