package com.bxm.localnews.thirdparty.controller;

import java.util.List;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.OperateUserPointDTO;
import com.bxm.localnews.thirdparty.dto.PointMallDTO;
import com.bxm.localnews.thirdparty.dto.PointStoreBaseDTO;
import com.bxm.localnews.thirdparty.dto.UserPointDTO;
import com.bxm.localnews.thirdparty.service.PointMallService;
import com.bxm.localnews.user.param.DeductPointParam;
import com.bxm.localnews.user.param.StoreNeceParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "3-08 积分商城相关接口", description = "积分商城相关接口操作")
@RestController
@RequestMapping("api/public/points")
public class PointMallController {

    private PointMallService pointMallService;

    @Autowired
    public PointMallController(PointMallService pointMallService) {
        this.pointMallService = pointMallService;
    }

    @ApiOperation(value = "3-08-1 根据栏位获取商品信息", notes = "type: 1:积分商城；2：商品；3：大转盘")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = false),
            @ApiImplicitParam(name = "type", value = "商品栏位", allowableValues = "1, 2, 3",
                    paramType = "path", dataType = "String", required = true)
    })
    @GetMapping(value = "/{type}")
    public Json<List<PointMallDTO>> pointsMallByType(@RequestParam(value = "userId", required = false) Long userId,
                                                     @PathVariable(value = "type") String type) {

        return ResultUtil.genSuccessResult(this.pointMallService.getPointsMallByType(userId, type));
    }

    @ApiOperation(value = "3-08-2 根据id获取跳转链接", notes = "id为0时，生成积分商城首页链接，为1时生成大转盘跳转链接")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "id", value = "商品id", required = true)
    })
    @GetMapping(value = "/{id}/url")
    public Json<String> pointsMallById(@PathVariable(value = "id") Long id,
                                       @RequestParam(value = "userId") Long userId) {
        return ResultUtil.genSuccessResult(this.pointMallService.getPointMallById(id, userId));
    }


    @ApiOperation(value = "3-08-3 用户金币信息", notes = "", hidden = true)
    @RequestMapping(value = "/get/balance", method = RequestMethod.GET)
    public UserPointDTO userBalance(StoreNeceParam storeNeceParam) {
        return this.pointMallService.selectJbBalanceByUserId(storeNeceParam);
    }

    @ApiOperation(value = "3-08-4 扣除用户金币", notes = "", hidden = true)
    @RequestMapping(value = "/deduct/balance", method = RequestMethod.POST)
    public OperateUserPointDTO deductBalance(DeductPointParam deductPointParam) {
        return this.pointMallService.deductUserBalance(deductPointParam);
    }

    @ApiOperation(value = "3-08-5 确认扣除用户金币", notes = "", hidden = true)
    @RequestMapping(value = "/confirm/deduct/balance", method = RequestMethod.POST)
    public PointStoreBaseDTO confirmDeductBalance(DeductPointParam deductPointParam) {
        return this.pointMallService.deductConfirmUserBalance(deductPointParam);
    }

    @ApiOperation(value = "3-08-6 添加用户金币", notes = "", hidden = true)
    @RequestMapping(value = "/balance", method = RequestMethod.POST)
    public OperateUserPointDTO addUserBalance(DeductPointParam deductPointParam) {
        return this.pointMallService.addUserBalance(deductPointParam);
    }
}
