package com.bxm.localnews.thirdparty.controller;

import java.util.List;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.ToolsDTO;
import com.bxm.localnews.thirdparty.service.ToolsService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2018/10/18 16:36
 * @desc
 */
@Api(tags = "3-12 工具类接口", description = "工具类接口相关操作")
@RestController
@RequestMapping("api/public/tools")
public class ToolsController {

    private ToolsService toolsService;

    @Autowired
    public ToolsController(ToolsService toolsService) {
        this.toolsService = toolsService;
    }

    @ApiOperation(value = "3-01-1 根据地区编码获取工具", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区编码", dataType = "String", required = true),
            @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String", required = true),
            @ApiImplicitParam(name = "isLogin", value = "0表示未登录，1表示已登陆", dataType = "String", required = true),
            @ApiImplicitParam(name = "locationType", value = "默认显示在广场，1显示在首页(version: 1.2版本)", dataType = "String", required = false)
    })
    @GetMapping("/areaCode")
    public Json<List<ToolsDTO>> getToolsByCode(@RequestParam("areaCode") String areaCode, @RequestParam("userId") Long userId,
                                               @RequestParam("isLogin") Integer isLogin, BasicParam basicParam,
                                               @RequestParam(value = "locationType", required = false) Byte locationType) {
        return ResultUtil.genSuccessResult(toolsService.getToolsByAreaCode(areaCode, userId, isLogin, basicParam, locationType));
    }
}
