package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.WechatDto;
import com.bxm.localnews.thirdparty.dto.WxUserInfo;
import com.bxm.localnews.thirdparty.service.WechatService;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@Api(tags = "3-15 微信小程序相关接口")
@RestController
@RequestMapping("api/public/wechat")
public class WechatAppletController {

    @Autowired
    private WechatService wechatService;

    @ApiOperation(value = "3-15-1 获取微信的openid及session_key")
    @RequestMapping(value = "/info", method = RequestMethod.GET)
    public Json<WxUserInfo> getWechatInfo(@ModelAttribute WechatDto wechatDto) {
        return ResultUtil.genSuccessResult(wechatService.getWechatInfo(wechatDto));
    }

    @ApiOperation(value = "3-15-2 获取微信小程序二维码接口")
    @RequestMapping(value = "/qrcode", method = RequestMethod.GET)
    public Json<String> getWechatQRCode(@ModelAttribute WechatDto wechatDto) {
        return ResultUtil.genSuccessResult(wechatService.getWechatQRCode(wechatDto));
    }

    @ApiOperation(value = "3-15-3 解密数据，创建账号，返回userId")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "encryptedData", value = "加密数据", required = true),
            @ApiImplicitParam(name = "sessionKey", value = "会话key", required = true),
            @ApiImplicitParam(name = "iv", value = "iv", required = true),
            @ApiImplicitParam(name = "inviteUserId", value = "邀请人id"),
            @ApiImplicitParam(name = "platform", value = "平台信息 1：安卓 2：IOS 3：H5", allowableValues = "1,2,3", required = true),
            @ApiImplicitParam(name = "area", value = "注册地区", required = false)
    })
    @RequestMapping(value = "/createUser", method = RequestMethod.GET)
    public Json<String> createUser(@RequestParam(value = "encryptedData") String encryptedData,
                                   @RequestParam(value = "sessionKey") String sessionKey,
                                   @RequestParam(value = "iv") String iv,
                                   @RequestParam(value = "inviteUserId", required = false) Long inviteUserId,
                                   @RequestParam(value = "platform") String platform,
                                   @RequestParam(value = "area", required = false) String area,
                                   HttpServletRequest request) {
        return ResultUtil.genSuccessResult(wechatService.createUser(encryptedData, sessionKey, iv,
                inviteUserId, WebUtils.getIpAddr(request), platform, area));
    }

    @ApiOperation(value = "3-15-4 存储用户formId")
    @RequestMapping(value = "/setUserFormId", method = RequestMethod.POST)
    public Json<Boolean> setUserFormId(@RequestParam(value = "userId") Long userId,
                                       @RequestParam(value = "formId") String formId) {
        return ResultUtil.genSuccessResult(wechatService.setUserFormId(userId, formId));
    }

}
