package com.bxm.localnews.thirdparty.controller.facade;

import java.util.List;

import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import com.bxm.localnews.thirdparty.service.AdvertService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2019/4/9 10:26
 * @desc
 */
@Api(tags = "3-99 [内部接口]广告接口", description = "广告接口相关操作")
@RestController
@RequestMapping("facade/advert")
public class AdvertFacadeController {

    @Autowired
    private AdvertService advertService;

    @ApiOperation(value = "3-01-1 根据类型获取广告", notes = "type广告类型 1:首页弹窗广告 2:日常任务广告 7:开屏广告 3：轮播广告 " +
            "4：个人中心轮播广告")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "type", value = "广告类型", allowableValues = "1,2,3,4,5,6,7,8,9,10,11",
                    dataType = "String", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "userId", value = "用户id", paramType = "query", dataType = "String")
    })

    @GetMapping("/type")
    public ResponseEntity<List<AdvertDTO>> getAdvertsByType(@RequestParam String type,
                                                            @RequestParam(required = false) String areaCode,
                                                            @RequestParam(required = false) Long userId) {
        return ResponseEntity.ok(this.advertService.queryAdByType(Byte.valueOf(type), areaCode, userId));
    }
}
