/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.controller;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaMessage;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.message.WxMaMessageRouter;
import com.bxm.localnews.thirdparty.config.WxMaConfiguration;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/public/wx/portal/{appid}"})
public class WxPortalController {
    private static final Logger log = LoggerFactory.getLogger(WxPortalController.class);

    @GetMapping(produces={"text/plain;charset=utf-8"})
    public String authGet(@PathVariable String appid, @RequestParam(name="signature", required=false) String signature, @RequestParam(name="timestamp", required=false) String timestamp, @RequestParam(name="nonce", required=false) String nonce, @RequestParam(name="echostr", required=false) String echostr) {
        log.info("\n\u63a5\u6536\u5230\u6765\u81ea\u5fae\u4fe1\u670d\u52a1\u5668\u7684\u8ba4\u8bc1\u6d88\u606f\uff1asignature = [{}], timestamp = [{}], nonce = [{}], echostr = [{}]", new Object[]{signature, timestamp, nonce, echostr});
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{signature, timestamp, nonce, echostr})) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u6838\u5b9e!");
        }
        WxMaService wxService = WxMaConfiguration.getMaService((String)appid);
        if (wxService.checkSignature(timestamp, nonce, signature)) {
            return echostr;
        }
        return "\u975e\u6cd5\u8bf7\u6c42";
    }

    @PostMapping(produces={"application/xml; charset=UTF-8"})
    public String post(@PathVariable String appid, @RequestBody String requestBody, @RequestParam(name="msg_signature", required=false) String msgSignature, @RequestParam(name="encrypt_type", required=false) String encryptType, @RequestParam(name="signature", required=false) String signature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce) {
        log.info("\n\u63a5\u6536\u5fae\u4fe1\u8bf7\u6c42\uff1a[msg_signature=[{}], encrypt_type=[{}], signature=[{}], timestamp=[{}], nonce=[{}], requestBody=[\n{}\n] ", new Object[]{msgSignature, encryptType, signature, timestamp, nonce, requestBody});
        WxMaService wxService = WxMaConfiguration.getMaService((String)appid);
        boolean isJson = Objects.equals(wxService.getWxMaConfig().getMsgDataFormat(), "JSON");
        if (StringUtils.isBlank((CharSequence)encryptType)) {
            WxMaMessage inMessage = isJson ? WxMaMessage.fromJson((String)requestBody) : WxMaMessage.fromXml((String)requestBody);
            inMessage.setContent("\u6587\u672c");
            this.route(inMessage, appid);
            return "success";
        }
        if ("aes".equals(encryptType)) {
            WxMaMessage inMessage = isJson ? WxMaMessage.fromEncryptedJson((String)requestBody, (WxMaConfig)wxService.getWxMaConfig()) : WxMaMessage.fromEncryptedXml((String)requestBody, (WxMaConfig)wxService.getWxMaConfig(), (String)timestamp, (String)nonce, (String)msgSignature);
            this.route(inMessage, appid);
            return "success";
        }
        throw new RuntimeException("\u4e0d\u53ef\u8bc6\u522b\u7684\u52a0\u5bc6\u7c7b\u578b\uff1a" + encryptType);
    }

    private void route(WxMaMessage message, String appid) {
        try {
            ((WxMaMessageRouter)WxMaConfiguration.getRouters().get(appid)).route(message);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

