package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.thirdparty.dto.OrderTabDTO;
import com.bxm.localnews.thirdparty.param.OrderTabsParam;
import com.bxm.localnews.thirdparty.service.impl.ThirdpartyJumpInfoService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "3-22 三方跳转信息的相关接口", description = "获取各个三方跳转信息的相关接口")
@RestController
@AllArgsConstructor
@RequestMapping("{version}/thirdparty/jumpInfo")
public class ThirdpartyJumpInfoController {

    private final ThirdpartyJumpInfoService thirdpartyJumpInfoService;


    @ApiOperation(value = "3-22-1 [v1]获取订单的tabs以及对应的跳转链接", notes = "获取订单的tabs以及对应的跳转链接")
    @GetMapping("orderTabs")
    @ApiVersion(1)
    public ResponseJson<List<OrderTabDTO>> orderTabs(OrderTabsParam param) {
        return ResponseJson.ok(thirdpartyJumpInfoService.orderTabs(param));
    }
}
