package com.bxm.localnews.thirdparty.domain;

import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import com.bxm.localnews.thirdparty.vo.Advert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface AdvertMapper {

    int deleteByPrimaryKey(Long id);

    int insert(Advert record);

    int insertSelective(Advert record);

    Advert selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(Advert record);

    int updateByPrimaryKey(Advert record);

    List<AdvertDTO> getListAds(@Param("pagesize") Integer pagesize);

    List<Advert> queryAdByType(@Param("type") Byte type);

    int getAdvertCount(AdvertDTO advertDTO);

    List<Advert> getAdvertByParams(AdvertDTO advertDTO);

    int updateAdvertStatusByCodes(@Param("codes") String[] codes, @Param("status") Byte status);

    int deleteByCode(String code);

    Advert getAdvertByCode(@Param("code") String code);

    List<String> getTypeByCode(@Param("code") String code);

    List<String> getCodeList(AdvertDTO advertDTO);

    List<Advert> getAdvertListByCode(@Param("code") String code);

    List<Advert> selectSchedule();

}
