package com.bxm.localnews.thirdparty.domain;

import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface AdvertPositionMapper {


    /**
     * 根据类型获取
     * @param positionType 广告位类型
     * @param positionBizId 某些广告位需要关联具体的业务id投放 如：商户类型id 栏目id等等
     * @return
     */
    List<AdvertDTO> getAdvertPositionListByType(@Param("positionType") Integer positionType,
                                                @Param("positionBizId") Long positionBizId,
                                                @Param("enableStatus") Integer enableStatus);

    /**
     *
     * @param positionType  : 广告位类型
     * @param enableStatus  ：启用状态
     * @param ids  ： 广告投放id集合
     * @return
     */
    List<AdvertDTO> getAdvertPositionListByIds(@Param("positionType") Integer positionType,
                                                @Param("enableStatus") Integer enableStatus,
                                                @Param("ids")List<Long> ids);
}