package com.bxm.localnews.thirdparty.domain;

import java.util.List;

import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import com.bxm.localnews.thirdparty.vo.Advert;
import com.bxm.localnews.thirdparty.vo.AdvertRecord;

import com.bxm.localnews.thirdparty.vo.AdvertVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface AdvertMapper {


    Advert selectByPrimaryKey(Long id);


    List<AdvertDTO> getListAds(@Param("pagesize") Integer pagesize);

    List<Advert> queryAdByType(@Param("type") Byte type, @Param("status") Byte status);

    int getAdvertCount(AdvertDTO advertDTO);

    /**
     * 批量插入用户查看广告信息
     *
     * @param advertRecordList
     * @return
     */
    int recordAdvert(@Param("advertRecordList") List<AdvertRecord> advertRecordList);

    /**
     * 获取广告素材id的信息
     * @param  materiaId: 广告素材id
     * @return 广告素材信息
     */
    AdvertVO getByMateriaId(@Param("materiaId")Long materiaId);
}
