package com.bxm.localnews.thirdparty.service;

import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import com.bxm.localnews.thirdparty.vo.Advert;

import java.util.List;

/**
 * Created by hsq 10:32 2018/2/8
 */
public interface AdvertService {

    /**
     * 广告列表
     * @param type 类型
     * @param areaCode 地区编码
     * @return 对应类型的广告列表
     */
    List<AdvertDTO> queryAdByType(Byte type, String areaCode);

    /**
     * 广告
     * @param id
     * @return
     */
    Advert selectByPrimaryKey(Long id);

    /**
     * 广告列表
     * @param size 长度
     * @return 固定长度的广告列表
     */
    List<AdvertDTO> getListAds(int size);

}
