package com.bxm.localnews.thirdparty.dto;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

public class WechatDto implements Serializable {
    private static final long serialVersionUID = -4480952612111393058L;
    /**
     * 用户登录凭证（有效期五分钟）。开发者需要在开发者服务器后台调用 api，使用 code 换取 openid 和 session_key 等信息
     */
    @ApiModelProperty("微信 code")
    private String code;

    @ApiModelProperty("最大32个可见字符，只支持数字，大小写英文以及部分特殊字符：!#$&'()*+,/:;=?@-._~，其它字符请自行编码为合法字符（因不支持%，中文无法使用 urlencode 处理，请使用其他编码方式）")
    private String scene;

    @ApiModelProperty("必须是已经发布的小程序存在的页面（否则报错），例如 'pages/index/index' ,根路径前不要填加'/',不能携带参数（参数请放在scene字段里），如果不填写这个字段，默认跳主页面")
    private String page;

    @ApiModelProperty("二维码的宽度,默认430")
    private Integer width;

    @ApiModelProperty("自动配置线条颜色，如果颜色依然是黑色，则说明不建议配置主色调,默认false")
    private Boolean autoColor;

    @ApiModelProperty("auto_color 为 false 时生效，使用 rgb 设置颜色 例如 {'r':'xxx','g':'xxx','b':'xxx'} 十进制表示,默认 {'r':'0','g':'0','b':'0'}")
    private String lineColor;

    @ApiModelProperty("是否需要透明底色， is_hyaline 为true时，生成透明底色的小程序码,默认false")
    private Boolean hyaline;

    @ApiModelProperty("邀请人ID")
    private Long inviteUserId;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getScene() {
        return scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }

    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public Integer getWidth() {
        if (null == width) {
            return 430;
        } else {
            return width;
        }
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Boolean getAutoColor() {
        if (null == autoColor) {
            return false;
        } else {
            return autoColor;
        }
    }

    public void setAutoColor(Boolean autoColor) {
        this.autoColor = autoColor;
    }

    public String getLineColor() {
        if (StringUtils.isBlank(lineColor)) {
            return "{'r':'0','g':'0','b':'0'}";
        } else {
            return lineColor;
        }
    }

    public void setLineColor(String lineColor) {
        this.lineColor = lineColor;
    }

    public Boolean getHyaline() {
        if (null == hyaline) {
            return false;
        } else {
            return hyaline;
        }
    }

    public void setHyaline(Boolean hyaline) {
        this.hyaline = hyaline;
    }

    public Long getInviteUserId() {
        return inviteUserId;
    }

    public void setInviteUserId(Long inviteUserId) {
        this.inviteUserId = inviteUserId;
    }
}
