package com.bxm.localnews.thirdparty.dto;

import com.bxm.localnews.activity.dto.UserVipInfoDTO;
import com.bxm.localnews.common.dto.AppVersionDTO;
import com.bxm.localnews.dto.UserAccountDTO;
import com.bxm.localnews.dto.UserRedPacketDTO;
import com.bxm.localnews.dto.VoteHomeDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class HomeWindowDTO {

    @ApiModelProperty("首页弹窗类型：" +
            "10000-版本更新弹窗  " +
            "10001-新人红包 " +
            "10002-引导提现  " +
            "10003-广告弹窗  " +
            "10004-VIP进度 " +
            "10005-投票引导  " +
            "10006-引导完善资料弹窗  " +
            "10010-H5弹框" +
            "")
    private Integer type;

    @ApiModelProperty("版本更新信息")
    private AppVersionDTO appVersionDTO;

    @ApiModelProperty("新人红包信息")
    private UserRedPacketDTO userRedPacketDTO;

    @ApiModelProperty("引导提现信息")
    private UserAccountDTO userAccountDTO;

    @ApiModelProperty("广告弹窗信息")
    private List<AdvertDTO> advertDTOList;

    @ApiModelProperty("VIP信息")
    private UserVipInfoDTO userVipInfoDTO;

    @ApiModelProperty("H5引导弹窗页面 如：蓝天救援队、个人主页等")
    private String url;

    @ApiModelProperty("投票引导-对应内容参数")
    private VoteHomeDTO voteHomeDTO;

}
