package com.bxm.localnews.thirdparty.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author zhaoyadong 2018/10/18 17:21
 * @desc
 */
@Data
@ApiModel(description = "微信用户信息")
public class WxUserInfo {

    @ApiModelProperty("用户openId")
    private String openId;

    @ApiModelProperty("用户的唯一标识(主要是为了让app和公众号共用一个账号)")
    private String unionId;

    @ApiModelProperty("会话密钥")
    private String sessionKey;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户头像")
    private String headImg;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("用户token")
    private String token;

    @ApiModelProperty("用户是否已经授权")
    private Boolean auth = true;

    @ApiModelProperty("用户手机号")
    private String phone;

    @ApiModelProperty("地区编码")
    private String locationCode;

    @ApiModelProperty("地区名称")
    private String locationName;

    @ApiModelProperty("微信用户是否为已注册用户，true表示为已注册")
    private Boolean regUser = false;
}
