package com.bxm.localnews.thirdparty.param;

import com.bxm.localnews.common.vo.BasicParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 百度广告平台回调参数
 * @author liujia
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BaiduAdvertCallbackParam extends BasicParam {

    private static final long serialVersionUID = -352870865897035953L;

    /**
     * 安卓特有，安卓imei号，进行了md5加密，当无imei时传递null
     */
    private String imei_md5;

    /**
     * android设备标识，进行标识md5加密，无androidid时传递null
     */
    private String android_id_md5;

    private String android_id;

    /**
     * ios特有，设备标识
     */
    private String idfa;

    /**
     * 广告点击客户端系统
     */
    private String os;

    /**
     * 客户端请求IP
     */
    private String ip;

    /**
     * user-agent
     */
    private String ua;

    /**
     * 请求时间戳
     */
    private Long ts;

    /**
     * 百度账号ID
     */
    private String userid;

    /**
     * 计划ID
     */
    private String pid;

    /**
     * 单元ID
     */
    private String uid;

    /**
     * 创意ID
     */
    private String aid;

    /**
     * 点击行为唯一标识
     */
    private String click_id;

    /**
     * 回调地址（百度接收反馈数据的地址）
     */
    private String callback_url;

    /**
     * 请求签名
     */
    private String sign;
}
