package com.bxm.localnews.thirdparty.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel(description = "广告")
@Data
public class AdvertDTO {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("广告跳转地址")
    private String address;

    @ApiModelProperty(" 缩略图 ")
    private String imgUrl;

    @ApiModelProperty("广告名称")
    private String title;

    @ApiModelProperty("开始时间")
    private Date startTime;

    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("广告倒计时时间（广告倒计时结束后自动关闭）")
    private Byte timeout;

    @ApiModelProperty("展示方式：0默认展示，1新用户展示一次，2所有用户只展示1次，3每天第一次打开App时展示")
    private Byte showType;

    @ApiModelProperty("[任务]主标题")
    private String taskMaintitle;

    @ApiModelProperty("[任务]副标题")
    private String taskSubtitle;

    @ApiModelProperty("[任务]文案")
    private String copy;

    @ApiModelProperty("素材内容")
    private String materialContent;

    @ApiModelProperty("按钮地址")
    private String iconUrl;

    @ApiModelProperty("素材id")
    private Long materialId;

    @ApiModelProperty("素材类型，1-文字，2-图片，3-任务素材，4：小程序客服，5：小程序分享")
    private Byte materialType;

    @ApiModelProperty("广告投放对象")
    private String deliveryObject;

    @ApiModelProperty("广告素材名称")
    private String name;
}
