package com.bxm.localnews.thirdparty.vo;

import com.bxm.localnews.common.vo.MPage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel(description = "广告")
@Data
public class Advert extends MPage {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("code")
    private String code;

    @ApiModelProperty("广告名称")
    private String title;

    @ApiModelProperty("缩略图")
    private String imgUrl;

    @ApiModelProperty("广告类型 1：首页弹窗广告 2：个人中心随机广告  3：赚钱中心轮播广告 4：列表广告 " +
            "5：赚钱中心公告 6：首页悬浮广告 7:开屏广告")
    private String type;

    @ApiModelProperty("广告跳转地址")
    private String address;

    @ApiModelProperty("添加时间")
    private Date addTime;

    @ApiModelProperty("状态 1：上架 2：下架  3：删除")
    private Byte status;

    @ApiModelProperty("广告商")
    private String author;

    @ApiModelProperty("广告商图标")
    private String authorImg;

    @ApiModelProperty("发送时间")
    private Date sendTime;

    @ApiModelProperty("发送类型0：立即发送1：定时发送")
    private Byte sendType;

    @ApiModelProperty("标签（多个之间用逗号隔开）")
    private String label;

    @ApiModelProperty("广告开始投放时间")
    private Date startTime;

    @ApiModelProperty("广告结束投放时间")
    private Date endTime;

    @ApiModelProperty("广告倒计时时间（广告倒计时结束后自动关闭）")
    private Byte timeout;

    @ApiModelProperty("是否全局通用（0：false，1：true）")
    private Byte globalFlag;

    @ApiModelProperty("展示方式：0默认展示，1新用户展示一次，2所有用户只展示1次，3每天第一次打开App时展示")
    private Byte showType;

    @ApiModelProperty("任务主标题")
    private String taskMaintitle;

    @ApiModelProperty("任务副标题")
    private String taskSubtitle;

    @ApiModelProperty("文案")
    private String copy;

    @ApiModelProperty("素材内容")
    private String materialContent;

    @ApiModelProperty("按钮地址")
    private String iconUrl;

    @ApiModelProperty("素材id")
    private Long materialId;

    @ApiModelProperty("素材类型，1-文字，2-图片，3-任务素材，4：小程序客服，5：小程序分享")
    private Byte materialType;

    @ApiModelProperty("广告投放对象")
    private String deliveryObject;
}