package com.bxm.localnews.thirdparty.dto;

import com.bxm.localnews.activity.dto.UserVipInfoDTO;
import com.bxm.localnews.common.dto.AppVersionDTO;
import com.bxm.localnews.common.dto.ExpandWindowDTO;
import com.bxm.localnews.dto.UserAccountDTO;
import com.bxm.localnews.dto.UserRedPacketDTO;
import com.bxm.localnews.dto.VoteHomeDTO;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.localnews.vo.TopicFacadeVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class HomeWindowDTO {

    @ApiModelProperty("首页弹窗类型：" +
            "10000-版本更新弹窗  " +
            "10001-新人红包 " +
            "10002-引导提现  " +
            "10003-广告弹窗  " +
            "10004-VIP进度 " +
            "10005-投票引导  " +
            "10006-引导完善资料弹窗  " +
            "10007-小纸条发布数弹窗  " +
            "10010-H5弹框" +
            "10011-话题弹窗" +
            "10012-插屏广告弹窗" +
            "10013-激活会员卡成功弹窗" +
            "10014-站外激活会员但是没有次数弹窗" +
            "10016-隐私协议弹窗" +
            // 中间有4个被引导弹窗占位了 不允许在这里定义
            "10021-普通新用户的引导弹窗" +
            "10022-vip新用户的引导弹窗" +
            "10024-3.9.0版本引导弹窗" +
            "10025-3.11.0 vip页面tab引导弹窗")
    private Integer type;

    @ApiModelProperty("版本更新信息")
    private AppVersionDTO appVersionDTO;

    @ApiModelProperty("新人红包信息")
    private UserRedPacketDTO userRedPacketDTO;

    @ApiModelProperty("引导提现信息")
    private UserAccountDTO userAccountDTO;

    @ApiModelProperty("广告弹窗信息")
    private List<AdvertVO> advertDTOList;

    @ApiModelProperty("VIP信息")
    private UserVipInfoDTO userVipInfoDTO;

    @ApiModelProperty("H5引导弹窗页面 如：蓝天救援队、个人主页等")
    private String url;

    @ApiModelProperty("投票引导-对应内容参数")
    private VoteHomeDTO voteHomeDTO;

    @ApiModelProperty("话题弹窗信息")
    private TopicFacadeVO topicFacadeVO;

    @ApiModelProperty("小纸条提示语")
    private String noteRemind;

    @ApiModelProperty("是否展示激活会员成功弹窗 true:展示 false：不展示")
    private Boolean vipActivationPop;

    @ApiModelProperty("弹窗拓展字段")
    private ExpandWindowDTO expandWindowDTO;

    @ApiModelProperty("是否展示员工绑定成功弹窗 true:展示 false：不展示")
    private Boolean bindPop;

    @ApiModelProperty("隐私协议字段")
    private PrivacyAgreementDTO privacyAgreementDTO;

    @ApiModelProperty("普通新用户的引导弹窗")
    private NormalNoviceUserGuideDTO normalNoviceUserGuide;

    @ApiModelProperty("vip新用户的引导弹窗")
    private VipNoviceUserGuideDTO vipNoviceUserGuide;

    @ApiModelProperty("3.9.0版本用户的引导弹窗")
    private NewVersionNoviceUserGuideDTO newVersionNoviceUserGuide;

    public HomeWindowDTO() {
    }

    public HomeWindowDTO(Integer type, String url) {
        this.type = type;
        this.url = url;
    }

}
