package com.bxm.localnews.thirdparty.dto;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * Created by Arei on 2018/10/16.
 */
@ApiModel(description = "用户信息（蓝领）")
public class UserInfoForJobDTO {
    @ApiModelProperty("昵称")
    private String nickname;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("注册渠道，7-app渠道/8-分享红包注册/9-老用户邀请/-10纸巾机扫码")
    private Long channelId;

    @ApiModelProperty("注册方式")
    private Integer registerClient;

    @ApiModelProperty("注册时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("注册IP")
    private String registerIp;

    @ApiModelProperty("最近登录时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String lastLoginTime;

    @ApiModelProperty("最近登录IP")
    private String lastLoninIp;

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Integer getRegisterClient() {
        return registerClient;
    }

    public void setRegisterClient(Integer registerClient) {
        this.registerClient = registerClient;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getRegisterIp() {
        return registerIp;
    }

    public void setRegisterIp(String registerIp) {
        this.registerIp = registerIp;
    }

    public String getLastLoginTime() {
        return lastLoginTime;
    }

    public void setLastLoginTime(String lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public String getLastLoninIp() {
        return lastLoninIp;
    }

    public void setLastLoninIp(String lastLoninIp) {
        this.lastLoninIp = lastLoninIp;
    }
}
