package com.bxm.localnews.thirdparty.param.bxm.advertisement.req;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

@Data
public class AdReq {

    /**
     * 是
     * ⼴告位token，从新义后台创建对应⼴广告位后获得，标识不同广告位。我们提供专⽤用测试⼴广告位token列列表供测试⽤用
     */
    @JSONField(name = "place_token")
    private String placeToken;

    /**
     * 否
     * 底价，单位为分
     */
    @JSONField(name = "floor_price")
    private Float floorPrice;

    /**
     * 是
     * ⼴告位宽度
     */
    private Integer w;


    /**
     * 是
     * ⼴告位⾼高度
     */
    private Integer h;

    /**
     * 否
     * ⼴告位位置, 1、插屏 2、开屏 3、⾮插屏非全屏
     */
    private Integer pos;

    /**
     * 否
     * ⽀支持的⼴告资源类型, 1:原⽣生，2:图片，3:视频，4:文字
     */
    private Integer[] types;

    /**
     * 否
     * 原⽣生⼴告信息, 当使⽤用原⽣⼴告位token请求时, 该字段为必须
     */
    @JSONField(name = "native")
    private NativeReq nativeObj;

}
