package com.bxm.localnews.thirdparty.param.bxm.advertisement.req;

import lombok.Data;

import java.util.List;

@Data
public class BXMAdvertisementReq {

    /**
     * 协议版本， 当前版本号
     * 必须：是
     */
    private String ver;

    /**
     * App对象信息
     * 必须：是
     */
    private AppReq app;

    /**
     * Site对象信息
     * 必须：否
     */
    private SiteReq site;

    /**
     * Device对象信息
     * 必须：是
     */
    private DeviceReq device;

    /**
     * User对象信息
     * 必须：否
     */
    private UserReq user;

    /**
     * Ad对象信息
     * 必须：是
     */
    private List<AdReq> ads;

    /**
     * 测试请求的标志，0表示不不是测试， 1表示测试， 默认不不是测试
     * 必须：否
     */
    private Integer test;

    /**
     * 是否需要https链接的标识，默认为0，0标识不不需要，1标识需要。 当为1时，需要返回的所有素材及追踪链接必须是https链接
     * 必须：否
     */
    private Integer https;

}
