/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.constant.AdvertStatusEunm;
import com.bxm.localnews.thirdparty.constant.GlobalFlagEnum;
import com.bxm.localnews.thirdparty.domain.AdvertAreaMapper;
import com.bxm.localnews.thirdparty.domain.AdvertMapper;
import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.thirdparty.vo.Advert;
import com.bxm.localnews.thirdparty.vo.AdvertArea;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertServiceImpl
implements AdvertService {
    private AdvertMapper advertMapper;
    private AdvertAreaMapper advertAreaMapper;
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public AdvertServiceImpl(AdvertMapper advertMapper, AdvertAreaMapper advertAreaMapper, RedisStringAdapter redisStringAdapter) {
        this.advertMapper = advertMapper;
        this.advertAreaMapper = advertAreaMapper;
        this.redisStringAdapter = redisStringAdapter;
    }

    private List<Advert> getAllAdvertByType(Byte type) {
        TypeReference<List<Advert>> typeReference = new TypeReference<List<Advert>>(){};
        List adverts = (List)this.redisStringAdapter.get(this.getAdvertListKey(type), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)adverts) && CollectionUtils.isNotEmpty((Collection)(adverts = this.advertMapper.queryAdByType(type, AdvertStatusEunm.PUTAWAY.getType())))) {
            this.redisStringAdapter.set(this.getAdvertListKey(type), (Object)adverts);
        }
        return adverts;
    }

    public List<AdvertDTO> queryAdByType(Byte type, String areaCode) {
        List<Advert> advertList = this.getAllAdvertByType(type);
        List<Object> longList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)areaCode)) {
            longList = this.getAdvertAreasByAreaCode(areaCode);
        }
        List<AdvertDTO> advertDTOList = this.getAdvertDTOs(advertList, longList);
        return advertDTOList;
    }

    public Advert selectByPrimaryKey(Long id) {
        return this.advertMapper.selectByPrimaryKey(id);
    }

    public List<AdvertDTO> getListAds(int size) {
        return this.advertMapper.getListAds(Integer.valueOf(size));
    }

    private List<AdvertDTO> getAdvertDTOs(List<Advert> advertList, List<Long> longList) {
        ArrayList advertDTOList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(advertList)) {
            for (Advert advert : advertList) {
                if (GlobalFlagEnum.IS_NOT_GLOBAL.getState().equals(advert.getGlobalFlag()) && !longList.contains(advert.getId())) continue;
                AdvertDTO advertDTO = this.getAdvertDTOByAdvert(advert);
                advertDTOList.add(advertDTO);
            }
        }
        return advertDTOList;
    }

    private KeyGenerator getAdvertListKey(Byte type) {
        return RedisConfig.THIRDPARTY_TYPE_ADVERT.copy().appendKey((Object)type).appendKey((Object)"list");
    }

    private AdvertDTO getAdvertDTOByAdvert(Advert advert) {
        AdvertDTO advertDTO = new AdvertDTO();
        advertDTO.setTitle(advert.getTitle());
        advertDTO.setAddress(advert.getAddress());
        advertDTO.setImgUrl(advert.getImgUrl());
        advertDTO.setStartTime(advert.getStartTime());
        advertDTO.setEndTime(advert.getEndTime());
        advertDTO.setTimeOut(advert.getTimeout());
        return advertDTO;
    }

    private List<Long> getAdvertAreasByAreaCode(String areaCode) {
        List advertAreas = this.advertAreaMapper.getAllAdvertAreaByAreaCode(areaCode);
        ArrayList longList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)advertAreas)) {
            for (AdvertArea advertArea : advertAreas) {
                longList.add(advertArea.getAdvertId());
            }
        }
        return longList;
    }
}

