/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.config.ThirdPartyProperties;
import com.bxm.localnews.thirdparty.domain.MachineRecordMapper;
import com.bxm.localnews.thirdparty.dto.MachineBaseResponse;
import com.bxm.localnews.thirdparty.dto.MachineResponse;
import com.bxm.localnews.thirdparty.param.MachineCallbackParam;
import com.bxm.localnews.thirdparty.service.MachineService;
import com.bxm.localnews.thirdparty.vo.MachineRecordBean;
import com.bxm.localnews.thirdparty.vo.MachineState;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.RandomUtils;
import com.google.common.collect.Maps;
import com.qq.weixin.mp.aes.AesException;
import com.qq.weixin.mp.aes.SHA1;
import com.qq.weixin.mp.aes.WXBizMsgCrypt;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MachineServiceImpl
extends BaseService
implements MachineService {
    private String openPaperUrl = "http://open.yilepie.com/app/index.php?c=api&a=opaper";
    private String verifyUrl = "http://open.yilepie.com/app/index.php?c=api&a=verify";
    private ThirdPartyProperties thirdPartyProperties;
    private HttpClientService httpClientService;
    private MachineRecordMapper machineRecordMapper;

    @Autowired
    public MachineServiceImpl(ThirdPartyProperties thirdPartyProperties, HttpClientService httpClientService, MachineRecordMapper machineRecordMapper) {
        this.thirdPartyProperties = thirdPartyProperties;
        this.httpClientService = httpClientService;
        this.machineRecordMapper = machineRecordMapper;
    }

    @Override
    public Json<MachineState> sendPaper(String machineId, String devcId) {
        Json result = Json.build((Object)new MachineState(0));
        if (this.machineRecordMapper.hasRecord(devcId) > 0) {
            return result.setErrorMsg("\u60a8\u5df2\u7ecf\u9886\u53d6\u8fc7\u7eb8\u5dfe\u4e86").setResult((Object)new MachineState(2));
        }
        MachineResponse onlineResponse = this.getMachineOnlineStatus(machineId);
        if (onlineResponse != null && "1".equals(onlineResponse.getStatus())) {
            boolean openPaperResult = this.buildOpenpaperRequest(machineId, devcId);
            if (!openPaperResult) {
                result.setErrorMsg("\u8bbe\u5907\u54cd\u5e94\u72b6\u6001\u5f02\u5e38").setResult((Object)new MachineState(3));
            }
        } else {
            result.setErrorMsg("\u8bbe\u5907\u6545\u969c").setResult((Object)new MachineState(3));
        }
        return result;
    }

    @Override
    public MachineBaseResponse sendPaperSuccessCallback(String paramData, String timestamp, String nonce, String signature) {
        try {
            String responseJson = this.getMsgCrypt().decryptMsg(signature, timestamp, nonce, paramData);
            MachineCallbackParam param = (MachineCallbackParam)JSONObject.parseObject((String)responseJson, MachineCallbackParam.class);
            if (null == param) {
                this.logger.error("\u975e\u6cd5\u8bf7\u6c42,\u8bf7\u6c42\u53c2\u6570\uff1aparamData[{}],timestamp:[{}],nonce:[{}],signatrue:[{}]", new Object[]{paramData, timestamp, nonce, signature});
            } else if ("PostLogin".equalsIgnoreCase(param.getTradeType())) {
                this.logger.info("PostLogin:[{}]\u8bbe\u5907\u5df2\u4e0a\u7ebf", (Object)param.getImei());
            } else if ("PostTask".equalsIgnoreCase(param.getTradeType())) {
                this.machineRecordMapper.updateRecord(param.getTaskId());
                this.logger.info("PostTask:\u51fa\u7eb8\u8bb0\u5f55ID\uff1a{},\u51fa\u7eb8\u8bbe\u5907ID\uff1a{}\uff0c\u51fa\u7eb8\u65f6\u95f4\uff1a{}", new Object[]{param.getTaskId(), param.getImei(), param.getOpTime()});
            } else if ("PostClose".equalsIgnoreCase(param.getTradeType())) {
                this.logger.info("PostClose:[{}]\u8bbe\u5907\u5df2\u4e0b\u7ebf", (Object)param.getImei());
            } else if ("PostError".equalsIgnoreCase(param.getTradeType())) {
                this.logger.info("PostError:[{}]\u8bbe\u5907\u5f02\u5e38", (Object)param.getImei());
            }
        }
        catch (AesException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return MachineBaseResponse.build();
    }

    private WXBizMsgCrypt getMsgCrypt() throws AesException {
        return new WXBizMsgCrypt(this.thirdPartyProperties.getMachineToken(), this.thirdPartyProperties.getMachineEncodingAESKey(), this.thirdPartyProperties.getMachineAppId());
    }

    @Override
    public MachineResponse getMachineOnlineStatus(String machineId) {
        String jsonBody = JSON.toJSONString((Object)new OnlineRequest(machineId));
        String currentMillis = System.currentTimeMillis() + "";
        String nonce = RandomUtils.getRandomStr((int)6, (boolean)true);
        try {
            String afterEncrypt = this.getMsgCrypt().encryptMsg(jsonBody, currentMillis, nonce);
            String signature = SHA1.getSHA1(this.thirdPartyProperties.getMachineToken(), currentMillis, nonce, afterEncrypt);
            return this.post(this.verifyUrl, currentMillis, nonce, afterEncrypt, signature);
        }
        catch (AesException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private MachineResponse post(String url, String currentMillis, String nonce, String afterEncrypt, String signature) {
        HashMap postParamMap = Maps.newHashMap();
        postParamMap.put("ParamData", afterEncrypt);
        postParamMap.put("AppId", this.thirdPartyProperties.getMachineAppId());
        postParamMap.put("TimeStamp", currentMillis);
        postParamMap.put("Nonce", nonce);
        postParamMap.put("Signature", signature);
        String response = this.httpClientService.doPost(url, (Map)postParamMap);
        this.logger.info("post url:" + url);
        this.logger.info("post response:" + response);
        return (MachineResponse)JSONObject.parseObject((String)response, MachineResponse.class);
    }

    private boolean buildOpenpaperRequest(String machineId, String devcId) {
        String taskId = this.nextSequence().toString();
        RequestBody body = new RequestBody(machineId, taskId);
        String jsonBody = JSON.toJSONString((Object)body);
        String currentMillis = System.currentTimeMillis() + "";
        String nonce = RandomUtils.getRandomStr((int)6, (boolean)true);
        try {
            String afterEncrypt = this.getMsgCrypt().encryptMsg(jsonBody, currentMillis, nonce);
            String signature = SHA1.getSHA1(this.thirdPartyProperties.getMachineToken(), currentMillis, nonce, afterEncrypt);
            MachineResponse response = this.post(this.openPaperUrl, currentMillis, nonce, afterEncrypt, signature);
            if (response != null && response.getResultCode() == 0) {
                MachineRecordBean entity = new MachineRecordBean();
                entity.setId(Long.valueOf(taskId).longValue());
                entity.setAddTime(new Date());
                entity.setMachineId(machineId);
                entity.setDevcId(devcId);
                entity.setStatus(0);
                this.machineRecordMapper.insert(entity);
                return true;
            }
            return false;
        }
        catch (AesException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public class OnlineRequest {
        @JSONField(name="IMEI")
        private String imei;

        OnlineRequest(String imei) {
            this.imei = imei;
        }

        public String getImei() {
            return this.imei;
        }

        public void setImei(String imei) {
            this.imei = imei;
        }
    }

    public static class RequestBody {
        @JSONField(name="IMEI")
        private String imei;
        @JSONField(name="TaskId")
        private String taskId;
        @JSONField(name="Number")
        private int number = 1;

        RequestBody(String imei, String taskId) {
            this.imei = imei;
            this.taskId = taskId;
        }

        public String getImei() {
            return this.imei;
        }

        public void setImei(String imei) {
            this.imei = imei;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }
    }
}

